/* Copyright 2005 VMware, Inc.	All rights reserved. -- VMware Confidential */

/**
 * public class CdDvdDeviceButton
 * extends vpx.context.AbstractDeviceButton
 *
 * A virtual cd/dvd drive toolbar button.
 *
 * @version 1.0 (Jun 29, 2006)
 */

/**
 * Creates a new virtual cd/dvd drive device menu button that will respond to
 * updates on the given view id.
 *
 * @param view [DOM Level 2 Views]AbstractView
 *    The context in which to create the button
 * @param vmViewId String
 *    The id of the server-side view that will provide updates that pertain to
 *    this button
 * @param dataItemId String
 *    The id of the server view's cd/dvd data item that corresponds to this
 *    button
 * @param name String
 *    The name of the CD/DVD
 * @param connected boolean
 *    true if the device is currently connected; false otherwise
 * @param controllerType String
 *    The type of controller the device uses (SCSI vs. IDE)
 * @param controllerId String
 *    The id of the controller
 * @param deviceNumber String
 *    The device node number
 */
vpx.context.CdDvdDeviceButton = function (view, vmViewId, dataItemId, name, connected,
                                          controllerType, controllerId, deviceNumber) {

   vpx.context.AbstractDeviceButton.call(this, view, vmViewId, dataItemId, name, connected);

   this.setControllerType(controllerType);
   this.setControllerId(controllerId);
   this.setDeviceNumber(deviceNumber);
};

// CdDvdDeviceButton extends vpx.context.AbstractDeviceButton
vpx.context.CdDvdDeviceButton.prototype = new vpx.context.AbstractDeviceButton(vpx.ABSTRACT_PASS);
vpx.context.CdDvdDeviceButton.prototype.constructor = vpx.context.CdDvdDeviceButton;

// Shorthand for brevity's sake
var _c = vpx.context.CdDvdDeviceButton;// Class
var _i = _c.prototype;                 // Instance
_i._concrete = true;                   // vpx system flag for concrete classes

// class constants
_c.ICON_CLASS_CONNECTED = "cdDvdDrive-16x16 icon";
_c.ICON_CLASS_DISCONNECTED = "cdDvdDriveDisconnected-16x16 icon";

// Instance variables
_i.controllerType = null;              // protected String
_i.controllerId = null;                // protected String
_i.deviceNumber = null;                // protected String

/**
 * Gets the value of this device's controller type.
 *
 * @return String
 *    The controller type of this device
 */
_i.getControllerType = function() {
   return this.controllerType;
};

/**
 * Sets the value of this device's controller type.
 *
 * @param str String
 *    The new controller type
 */
_i.setControllerType = function(str) {
   this.controllerType = str;
};

/**
 * Gets the value of this device's controller id.
 *
 * @return String
 *    The controller id of this device
 */
_i.getControllerId = function() {
   return this.controllerId;
};

/**
 * Sets the value of this device's controller id.
 *
 * @param str String
 *    The new controller id
 */
_i.setControllerId = function(str) {
   this.controllerId = str;
};

/**
 * Gets the value of this device's device number.
 *
 * @return String
 *    The device number of this device
 */
_i.getDeviceNumber = function() {
   return this.deviceNumber;
};

/**
 * Sets the value of this device's device number.
 *
 * @param str String
 *    The new device number
 */
_i.setDeviceNumber = function(str) {
   this.deviceNumber = str;
};


/*************************************************************************
 * All data and procedures below this point are part of the internal     *
 * implementation, should not be accessed outside of this module, and    *
 * are subject to change.                                                *
 *************************************************************************/


/*
 * (non-doc)
 *
 * @see AbstractDeviceButton#_processChange(Object)
 */
_i._processChange = function(change) {
   // super._processChange(change)
   var spr = vpx.context.AbstractDeviceButton.prototype;
   if (spr._processChange.call(this, change)) {
      // We've already handled the change
      return true;
   }

   switch (change.property) {

   case "controllerType":
      this.setControllerType(change.value);
      this.__updateHeader();
      return true;

   case "controllerId":
      this.setControllerId(change.value);
      this.__updateHeader();
      return true;

   case "deviceNumber":
      this.setDeviceNumber(change.value);
      this.__updateHeader();
      return true;

   default:
      // Ignore
      return false;

   }

};

/**
 * Updates the text of the button menu's header item.
 */
_i.__updateHeader = function() {
   var header = this.getMenuButton().getMenuComponent(0);
   var txt = this.getName() + " (" + this.getControllerType() + " " +
      this.getControllerId() + ":" + this.getDeviceNumber() + ")";
   header.setText(txt);
};
