/* Copyright 2005 VMware, Inc.	All rights reserved. -- VMware Confidential */

/**
 * public class FloppyDeviceButton
 * extends vpx.context.AbstractDeviceButton
 *
 * A virtual floppy drive toolbar button.
 *
 * @version 1.0 (Jun 29, 2006)
 */

/**
 * Creates a new virtual floppy drive device menu button that will respond to
 * updates on the given view id.
 *
 * @param view [DOM Level 2 Views]AbstractView
 *    The context in which to create the button
 * @param vmViewId String
 *    The id of the server-side view that will provide updates that pertain to
 *    this button
 * @param dataItemId String
 *    The id of the server view's floppy data item that corresponds to this
 *    button
 * @param name String
 *    The name of the floppy
 * @param connected boolean
 *    true if the device is currently connected; false otherwise
 */
vpx.context.FloppyDeviceButton = function (view, vmViewId, dataItemId, name, connected) {
   vpx.context.AbstractDeviceButton.call(this, view, vmViewId, dataItemId, name, connected);
};

// FloppyDeviceButton extends vpx.context.AbstractDeviceButton
vpx.context.FloppyDeviceButton.prototype = new vpx.context.AbstractDeviceButton(vpx.ABSTRACT_PASS);
vpx.context.FloppyDeviceButton.prototype.constructor = vpx.context.FloppyDeviceButton;

// Shorthand for brevity's sake
var _c = vpx.context.FloppyDeviceButton;// Class
var _i = _c.prototype;                  // Instance
_i._concrete = true;                    // vpx system flag for concrete classes

// class constants
_c.ICON_CLASS_CONNECTED = "floppyDrive-16x16 icon";
_c.ICON_CLASS_DISCONNECTED = "floppyDriveDisconnected-16x16 icon";
