/* Copyright 2005 VMware, Inc.	All rights reserved. -- VMware Confidential */

/**
 * public class NicDeviceButton
 * extends vpx.context.AbstractDeviceButton
 *
 * A virtual network adapter toolbar button.
 *
 * @version 1.0 (Jun 29, 2006)
 */

/**
 * Creates a new virtual network card device menu button that will respond to
 * updates on the given view id.
 *
 * @param view [DOM Level 2 Views]AbstractView
 *    The context in which to create the button
 * @param vmViewId String
 *    The id of the server-side view that will provide updates that pertain to
 *    this button
 * @param dataItemId String
 *    The id of the server view's nic data item that corresponds to this button
 * @param name String
 *    The name of the nic
 * @param connected boolean
 *    true if the device is currently connected; false otherwise
 */
vpx.context.NicDeviceButton = function (view, vmViewId, dataItemId, name, connected) {
   vpx.context.AbstractDeviceButton.call(this, view, vmViewId, dataItemId, name, connected);
};

// NicDeviceButton extends vpx.context.AbstractDeviceButton
vpx.context.NicDeviceButton.prototype = new vpx.context.AbstractDeviceButton(vpx.ABSTRACT_PASS);
vpx.context.NicDeviceButton.prototype.constructor = vpx.context.NicDeviceButton;

// Shorthand for brevity's sake
var _c = vpx.context.NicDeviceButton;  // Class
var _i = _c.prototype;                 // Instance
_i._concrete = true;                   // vpx system flag for concrete classes

// class constants
_c.ICON_CLASS_CONNECTED = "networkAdapter-16x16 icon";
_c.ICON_CLASS_DISCONNECTED = "networkAdapterDisconnected-16x16 icon";
