/**
 * Runs setup code that can only be run once the html page body has loaded
 * completely.
 */
function handleBodyLoad() {
   // Shorthand for brevity's sake
   var c = vpx.context;
   c.xmlSpec = vpx.net.XmlSpec.fromUrl(c.ACTION_ITEM);
   c.xmlSpec.setAttribute(c.PARAM_NAME_NAV_ITEM, "/");

   c.paginator = new vpx.browser.Paginator($("paginatorContainer"));
   c.browser = new vpx.browser.Browser($("browserContainer"), c.PAGE_SIZE, c.FIXED_HEIGHT, true);
   c.paginator.setProvider(c.browser);

   c.navigator = new vpx.browser.Navigator($("navigatorContainer"));
   c.navigator.setProvider(c.browser);

   c.browser.registerListener(vpx.browser.EVENT.SELECTION, handleSelectionChanged);
   c.browser.registerListener(vpx.browser.EVENT.SORT, handleSort);
   c.browser.registerListener(vpx.browser.EVENT.PAGE, handlePage);
   c.browser.registerListener(vpx.browser.EVENT.NAVIGATE, handleNavigate);
   c.browser.registerListener(vpx.browser.EVENT.ERROR, handleError);
   c.browser.requestData(c.xmlSpec);
}

/**
 * Runs cleanup code that prepares the page to be safely destroyed.
 */
function handleBodyUnload() {
   // Shorthand for brevity's sake
   var c = vpx.context;

   if (c.updatesRunning) {
      vpx.log.info("Datastore Browser: Stopping updates");
      tle.ignoreUpdates(c.updatesId);
      c.updatesRunning = false;
   }
}

/**
 * Handles the event of the current navigation browser's selected item having
 * changed.  It notifies the workspace pane of the selection.
 *
 * @param browser vpx.browser.Browser
 *    The object that fired the event
 */
function handleSelectionChanged(browser) {

   var c = vpx.context;
   var viewType = c.viewType;
   if (viewType == c.DISKFILE_BROWSER) {
      handleSelectionDiskFileBrowser(browser);
   } else {
      handleSelectionDatastoreBrowser(browser);
   }

}


function handleSelectionDatastoreBrowser(browser) {

   var c = vpx.context;
   var viewType = c.viewType;

   var selected = browser.getSelected()[0];
   document.getElementById("fileNameInput").value = "";   
   document.getElementById("fileType").value = "";
   if (!isNull(selected)) {

      var id = selected.getId();
      var viewType = c.viewType;

      var fileType = selected.getAttribute("fileType");   
         
      if (!isNull(fileType)) {
        document.getElementById("fileType").value=fileType; 
        if ((viewType == c.DATASTORE_BROWSER && fileType == c.DATASTORE_BROWSER) ||
	     (viewType == c.CDDVD_BROWSER && fileType == c.CDDVD_BROWSER) ||
	     (viewType == c.FLOPPY_BROWSER && fileType == c.FLOPPY_BROWSER ||
	     viewType == c.TYPE_OTHER && fileType == c.TYPE_OTHER)) {

	      document.getElementById("fileNameInput").value=id;
	     }
      }

      if (viewType == c.DATASTORE_BROWSER) {
	 var size = selected.getAttribute("freespace");
	 if (!isNull(size)) {
	   document.getElementById("freeSpace").value=size;

	 }
      }
   }
}

function handleSelectionDiskFileBrowser(browser) {

   var selected = browser.getSelected()[0];
   if (!isNull(selected)) {
        var id = selected.getId();
        document.getElementById("diskFileBrowser").value=id;

        // get the fileType and diskSize attributes
        var fileType = selected.getAttribute("fileType");
        document.getElementById("fileType").value=fileType;

        var diskSize = selected.getAttribute("diskSize");
        if (!isNull(diskSize)) {
          document.getElementById("diskSize").value=diskSize;
        }
        
        var backingType = selected.getAttribute("backingType");
        if (!isNull(backingType)) {
          document.getElementById("backingType").value=backingType;
        }
   }

   var location = browser.getLocation();
   if (!isNull(location)) {
     document.getElementById("navigationItem").value=location.getId();
   }
}

/**
 * Handles a GUI sort event for the current datastore browser.  It issues a
 * sorting action command to the browser's xml spec and re-requests browser
 * data.
 *
 * @param browser vpx.browser.Browser
 *    The object that fired the event
 * @param column vpx.browser.Column
 *    The column being sorted on
 * @param sortOrder const String
 *    The sort type (e.g. vpx.browser.SORT.ASC)
 */
function handleSort(browser, column, sortOrder) {
   // Shorthand for brevity's sake
   var c = vpx.context;

   c.xmlSpec.setAttribute(c.PARAM_NAME_SORT_COL, column.getName());
   c.xmlSpec.setAttribute(c.PARAM_NAME_SORT_DIR, sortOrder);
   browser.requestData(c.xmlSpec);
   c.xmlSpec.removeAttribute(c.PARAM_NAME_SORT_COL);
   c.xmlSpec.removeAttribute(c.PARAM_NAME_SORT_DIR);
}

/**
 * Handles a GUI page event for the current datastore browser.  It
 * issues the corresponding page action command to the browser's xml spec
 * and re-requests browser data.
 *
 * @param browser vpx.browser.Browser
 *    The object that fired the event
 * @param pageType const String
 *    The page command (e.g. vpx.browser.PAGE.FIRST)
 */
function handlePage(browser, pageType) {
   // Shorthand for brevity's sake
   var c = vpx.context;

   switch (pageType) {
   case vpx.browser.PAGE.PREV:
      c.xmlSpec.setAttribute(c.PARAM_NAME_PAGE, c.DC_PREV_PAGE);
      break;
   case vpx.browser.PAGE.NEXT:
      c.xmlSpec.setAttribute(c.PARAM_NAME_PAGE, c.DC_NEXT_PAGE);
      break;
   default:
      throw new Error("Unsupported page type: " + pageType);
   }

   browser.requestData(c.xmlSpec);
   c.xmlSpec.removeAttribute(c.PARAM_NAME_PAGE);

}


/**
 * Handles a GUI navigate event for the current datastore browser.  It issues
 * a navigate action command to the browser's xml spec and re-requests browser
 * data.
 *
 * @param browser vpx.browser.Browser
 *    The object that fired the event
 * @param baseItem vpx.ServerObj
 *    The object being navigated to
 */
function handleNavigate(browser, baseItem) {
   // Shorthand for brevity's sake
   var c = vpx.context;
   c.xmlSpec.setAttribute(c.PARAM_NAME_NAV_ITEM, encodeURIComponent(baseItem.getId()));
   c.xmlSpec.setAttribute("parentNode", "true");
   browser.requestData(c.xmlSpec);

}

/**
 * Handles error event. 
 *
 * @param browser vpx.browser.Browser
 *    The object that fired the event
 *
 */

function handleError(browser) {
   document.getElementById("fileNameInput").value="";
   document.getElementById("OK").disabled = true;  
   vpx.xua.addClass(document.getElementById("OK"), "disabled"); 
}
