var vpxWin;
var methods = {};

var serverPath, langID;
var cLocale	= navigator.userLanguage;
if (cLocale == null)
   cLocale = navigator.language;
  
if(cLocale.indexOf("zh") > -1) {
	langID = 'zh-CN';
} else if (cLocale.indexOf("tw") > -1 || cLocale.indexOf("hk") > -1 ) {
		langID = 'zh-TW';
} else {
	langID = '' + cLocale.charAt(0) + cLocale.charAt(1);
}

document.write('<script language="JavaScript" src="../html/' 
				  + 'en/resource.js"> type="text/javascript"></script>');
document.write('<script language="JavaScript" src="../html/' 
				  + langID + '/resource.js"> type="text/javascript"></script>');

methods.getContentDimension = function () {
   return vpx.xua.getDimension("windowPane");
};


methods.getTitle = function () {
   return this.title;
};


methods.setTitle = function (title) {
   this.title = title;

   switch (title.sourceType) {
      case this.SOURCE_TYPE_STRING:
	 $("windowTitle").innerHTML = title.source;
	 break;
      default:
	 throw "messageBox: Cannot set title. Source type not supported.";   
   }
};


methods.getContentPane = function () {
   return vpx.xua.viewport.getView("windowViewport");
};


function initContent(vpxWin) {
   var view = vpxWin.getContentPane();
   var page = vpx.xua.viewport.getPage(view);

   switch (vpxWin.content.sourceType) {
      case vpxWin.SOURCE_TYPE_URL:
	 vpx.xua.event.listen(vpx.xua.viewport.getElement(view),
	    "load", initContentCb);

	 page.location.href = vpxWin.content.source;
	 break;
      case vpxWin.SOURCE_TYPE_STRING:
	 page.open();
	 page.writeln(vpxWin.content.source);
	 page.close();

	 this.initContentCb();
	 break;
      case vpxWin.SOURCE_TYPE_DOM_NODE:
	 vpx.xua.cut(page.documentElement);
	 vpx.xua.append(page, vpxWin.content.source);

	 this.initContentCb();
	 break;
      default:
	 throw "messageBox: Cannot set content source. Source type not supported.";   
   }
};


function initContentCb(e) {
   var view = vpxWin.getContentPane();
   var page = vpx.xua.viewport.getPage(view);

   if (isDefined(view.initPane)) {
      view.initPane(vpxWin);
   } else {
      throw "messageBox: Content pane does not implement initPane.";
   }

   vpx.xua.event.listen($("windowClose"), "click", vpxWin.cancel.bind(vpxWin));

   vpxWin.ready();
};


methods.setFocus = function () {
   self.focus();
};


function initPane(o) {
   vpxWin = o;
   var handles = $("windowTitleCell");
   if (! isArray(handles)) { 
      handles = [handles];
   }

   // XXX: We should locate the draggable context programatically.
   vpxWin.context.vpx.drag.init(handles, [vpxWin.element]);
   vpxWin.context.vpx.drag.setBoundaryByElement(handles, vpxWin.context);
   vpxWin.context.vpx.drag.listen(handles, "start", dragStart);
   vpxWin.context.vpx.drag.listen(handles, "drag", dragDrag);
   vpxWin.context.vpx.drag.listen(handles, "end", dragEnd);

   extendObject(vpxWin, methods);

   document.onkeyup = function (e) {
      if (vpx.xua.event.getKeyCode(e) == 27) {
	 vpxWin.cancel();
      }
   };
   
   initContent(vpxWin);
};


dragStart = function (e) {
   vpx.xua.setStyle("windowViewport", "position", "absolute");
   var dim = vpx.xua.getDimension("windowViewport");
   vpx.xua.setPosition("windowViewport", new Position(0,0).subtract(dim.toPosition()));
   vpx.xua.setStyle("windowControls", "display", "none");
};


dragDrag = function (e) {
   window.status = vpx.xua.event.getPosition(e);
   return true;
};

dragEnd = function (e) {
   vpx.xua.setStyle("windowViewport", "position", "static");
   vpx.xua.setStyle("windowControls", "display", "");
};
