/* insertWordBreak --
 *   Inserts word break immediately after encountering the 
 *   break-point value. If the break-point-string is
 *   not specified then a word break will be inserted after
 *   every character in the original string:
 */
function insertWordBreak(originalString, breakPoint) {
   var retval = "";
   
   if (breakPoint == null) {
      breakPoint = '';
   }
   var oStringArr = originalString.split(breakPoint);   
   var oStringLen = oStringArr.length - 1; // Prevent adding a wbr after the last word.   
   for (i = 0; i < oStringLen; i++) {
      retval += oStringArr[i] + breakPoint + "<wbr>";
   }
   retval += oStringArr[i];   
   return retval;
}