/* Copyright 2004 VMware, Inc.  All rights reserved. -- VMware Confidential */

/**
* loginForm.js
* <p>
* Handles the login form submission, collecting user agent capabilities to send
* to the server, validating all required inputs were entered by the user, 
* alerting if any input is missing and focusing on the missing input field.
* <p>
* <b>Note:</b><br>
*  The validateLoginForm method is provided by the Struts validator framework 
*  and can viewed by :<br>
*     1. Viewing the HTML source code of the page linking to this javascript module
*     2. Viewing the javascript sections in the Struts validation-rules.xml file
*     3. Viewing the different validation method invocations in the Struts
*        validation.xml file.
*/

/**
* Triggered on the login form's submit event.<br> 
* Proceeds to submit the form only if all required fields were filled out by 
* the user, and only after collecting some capabilities from the user agent to 
* send to the server.
* 
* @return false - if validation on the login form has failed.
* <b>Note:</b> returning false in the form submission event causes the form 
* submission to cancel. 
*
*/

function submitLoginForm(formLogin){
   if(!validateLoginForm(formLogin)) { 
      return false;
   }
   fillBrowserCaps(formLogin);
}

/**
* Collects user agent capabilties and populates the corresponding form fields.<br>  
* <b>Note: </b><br>
* The form hidden inputs which are populated with these values are named in a 
* dotted notation fashion for ease of processing on the STRUTS side of the 
* application. Since this is the case, using a dotted notation to set the 
* fields' values will break the code. For example, the following will is not 
* correct - formLogin.clientCaps.appCodeName.value 
*  
* @param formLogin - the form to use when populating the collected user agent 
*  capabilities.
*/

function fillBrowserCaps(formLogin){
   formLogin["clientCaps.appCodeName"].value = window.navigator.appCodeName;
   formLogin["clientCaps.appMinorVersion"].value = window.navigator.appMinorVersion;
   formLogin["clientCaps.appName"].value = window.navigator.appName;
   formLogin["clientCaps.appVersion"].value = window.navigator.appVersion;
   formLogin["clientCaps.platform"].value = window.navigator.platform;
   formLogin["clientCaps.userAgent"].value = window.navigator.userAgent;
}