/* Copyright 2005 VMware, Inc.	All rights reserved. -- VMware Confidential */

/**
 * Constructor for a new ServerObj. This class is abstract, however, so
 * users should not invoke this constructor directly.	 Any attempt to do so
 * will result in an error being thrown.
 */
vpx.ServerObj = function() {
	// Abstract class
	if (arguments.length != 1 || arguments[0] != null) {
		throw new Error("ServerObj is abstract: cannot be instantiated");
	}

	if (this.instantiated) {
		this.id = null;
	}
};

/**
 * Gets the unique id of this server object.	 By definition, this id can be
 * passed to the server to uniquely identify a resource on the server.
 *
 * @return String
 *		The id of this server object
 */
vpx.ServerObj.prototype.getId = function() {
	return this.id;
};
