/* Copyright 2005 VMware, Inc.	All rights reserved. -- VMware Confidential */

/**
 * public class Session
 * extends Object
 *
 * TODO Document.
 *
 * @version 1.0 (Nov 17, 2005)
 */

/**
 * Constructs a new Session object.
 */
vpx.Session = function() {
   this.changes = {};
   this.nchanges = 0;
};

// Shorthand for brevity's sake
var _c = vpx.Session;                 // Class
var _i = _c.prototype;                // Instance
_i._concrete = true;                  // vpx system flag for concrete classes

// Instance variables
_i.changes = null;                    // private Hashtable
_i.nchanges = 0;                      // private int
_i.autoCommit = true;                 // private boolean
_i.url = vpx.getTle().getContextPath() + "/sessionAttr.do"; // private static String

/**
 * Binds a string to the current user's session, using the name specified. If
 * an object of the same name is already bound to the session, the object is
 * replaced.
 * <p/>
 * If the value passed in is <code>null</code>, this has the same effect as
 * calling <code>removeAttribute()</code>.
 *
 * @param name String
 *    The name to which the object is bound; cannot be <code>null</code>
 * @param value String
 *    The string to be bound
 */
_i.setAttribute = function(name, value) {
   if (this.changes[name] == undefined) {
      this.nchanges++;
   }
   this.changes[name] = value;
   if (this.autoCommit) {
      this.commit();
   }
};

/**
 * Removes the object bound with the specified name from the current user's
 * session. If the session does not have an object bound with the specified
 * name, this method does nothing.
 *
 * @param name
 *    The name of the object to remove from the current user's session
 */
_i.removeAttribute = function(name) {
   this.setAttribute(name, null);
};

/**
 * Sets the <code>autoCommit</code> flag, which determines whether this session
 * will automatically notify the server of changes as they happen.  If set to
 * false, the server will only be notified of changes when
 * <code>commit()</code> is invoked.
 *
 * @param b boolean
 *    true to turn autoCommit on; false to turn it off
 */
_i.setAutoCommit = function(b) {
   this.autoCommit = b;
   if (b && this.nchanges > 0) {
      this.commit();
   }
};

/**
 * Reports the value of the <code>autoCommit</code> flag, which determines
 * whether this session will automatically notify the server of changes as they
 * happen.
 *
 * @return boolean
 *    true if autoCommit is on; false if it is off
 */
_i.isAutoCommit = function() {
   return this.autoCommit;
};

/**
 * Commits any pending changes that have not yet been sent to the server.  If
 * there are no pending changes, this does nothing.  If <code>autoCommit</code>
 * is on, this will be onvoked automatically as needed by the API.
 */
_i.commit = function() {
   if (this.nchanges == 0) {
      // Trivial success
      return;
   }

   var attrs = "";
   var i = 0;
   for (var name in this.changes) {
      if (i++ > 0) {
         attrs += ",";
      }
      attrs += name;

      var value = this.changes[name];
      if (value != null) {
         attrs += "=" + value;
      }

      delete this.changes[name];
      this.nchanges--;
   }
   var url = this.url + "?attrs=" + vpx.xua.urlEncode(attrs);
   var req = tle.getRequest(url);
   try {
      req.send();
   } finally {
      tle.releaseRequest(req);
   }
   delete attrs;
   delete i;
};

// Static session to be used by all
vpx.session = new vpx.Session();
