/* Copyright 2005 VMware, Inc.	All rights reserved. -- VMware Confidential */

// Create namespaces for VMware WebCenter JavaScript packages, but only if not present yet.
if(!window.vpx) {

	var vpx = {
	   ABSTRACT_PASS : Math.random(),   /**
	                                     * Opaque value to be passed to abstract
	                                     * constructors. This allows these abstract
	                                     * classes to be instantiated strictly for
	                                     * the purpose of acting as prototype
	                                     * objects for subclasses.
	                                     */
	
	   FEATURE : {},                    /**
	                                     * An associative array of features that
	                                     * the user agent supports, as they pertain
	                                     * to the VPX API.
	                                     */
	
	   _tle : null,                     /**
	                                     * The VPX top level element, of type
	                                     * [DOM Level 2 Views]AbstractView
	                                     */
	
	   context : {}                     /**
	                                     * A general-purpose hashtable that acts as
	                                     * a reserved VPX-JS "package" in which
	                                     * developers may place namespace variables
	                                     * and functions to ensure no collisions
	                                     * with other JS code in the page.
	                                     */
	};
	
	try {
	   vpx.FEATURE.EVENTS = document.implementation.hasFeature("Events", 2.0);
	   if (!vpx.FEATURE.EVENTS && document.createEvent) {
	      // We only really care about document.createEvent()
	      vpx.FEATURE.EVENTS = true;
	   }
	} catch (ex) {
	   vpx.FEATURE.EVENTS = false;
	}
	
	try {
		vpx.FEATURE.TRAVERSAL = document.implementation.hasFeature("Traversal", 2.0);
	   if (!vpx.FEATURE.TRAVERSAL && document.createTreeWalker) {
	      // We only really care about document.createTreeWalker()
	      vpx.FEATURE.TRAVERSAL = true;
	   }
	} catch (ex) {
		vpx.FEATURE.TRAVERSAL = false;
	}
   
}



/**
 * Static method to get the VPX top level view (TLE). This object is found
 * lazily and cached once found, since it's a static var.
 *
 * @return [DOM Level 2 Views]AbstractView
 *    The VPX top level element
 */
vpx.getTle = function() {
   if (vpx._tle == null) {
      // Lazily find tle
      var tle = undefined;
      var win = self;
      while (true) {
         if (win.isWebcenterTle) {
            tle = win;
            break;
         } else if (win == win.top) {
            break;
         }
         win = win.parent;
      }
      vpx._tle = tle;
   }
   if (vpx._tle == undefined) {
      throw new Error("VPX top level view not found!");
   }
   return vpx._tle;
};
