/* Copyright 2005 VMware, Inc.	All rights reserved. -- VMware Confidential */

/**
 * Constructs a new BranchNode.
 *
 * @param browser vpx.browser.Browser
 *    The container of this node
 * @param id String
 *    The id of this node, unique among all nodes in this browser
 * @param iconClass String
 *		The CSS class for the iconic representation of this node
 */
vpx.browser.BranchNode = function(browser, id, iconClass) {
   // super(browser, id, icon);
   vpx.browser.Node.call(this, browser, id, iconClass);
};

// BranchNode extends vpx.browser.Node
vpx.browser.BranchNode.prototype = new vpx.browser.Node(null);
vpx.browser.BranchNode.prototype.constructor = vpx.browser.BranchNode;

/*
 * (non-doc)
 *
 * @see Object#toString()
 */
vpx.browser.BranchNode.prototype.toString = function() {
   return "[Object BranchNode (" + this.id + ")]";
};
