/* Copyright 2005 VMware, Inc.	All rights reserved. -- VMware Confidential */

/**
 * public class NodeButton
 * extends vpx.gui.ToggleButton
 *
 * TODO Document.
 *
 * @version 1.0 (Nov 2, 2005)
 */

/**
 * Constructs a new NodeButton.
 *
 * @param view [DOM Level 2 Views]AbstractView
 *    The context in which to create the menu
 * @param text String
 *    The text of the toggle button
 * @param icon vpx.gui.Icon
 *    The image that the button should display
 * @param selected boolean
 *    if true, the button is initially selected; otherwise, the button is
 *    initially unselected
 */
vpx.browser.NodeButton = function(view, text, icon, selected) {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }

   // super(view, text, icon, selected)
   vpx.gui.ToggleButton.call(this, view, text, icon, selected);

   this.setModel(new vpx.browser.NodeButton.NodeButtonModel());
};

// NodeButton extends vpx.gui.Menu
vpx.browser.NodeButton.prototype = new vpx.gui.ToggleButton(vpx.ABSTRACT_PASS);
vpx.browser.NodeButton.prototype.constructor = vpx.browser.NodeButton;

// Shorthand for brevity's sake
var _c = vpx.browser.NodeButton;      // Class
var _i = _c.prototype;                // Instance
_i._concrete = true;                  // vpx system flag for concrete classes

// Instance variables
_i.uiClassID = "NodeButtonUI";        // private static final String

/**
 * (non-Javadoc)
 *
 * @see Object#toString()
 */
_i.toString = function() {
   return "[Object vpx.browser.NodeButton]";
};

/**
 * public static class NodeButtonModel
 * extends vpx.gui.ToggleButtonModel
 *
 * The NodeButton model
 *
 * @version 1.0 (Nov 15, 2005)
 */

/**
 * Constructs a new NodeButton Model.
 */
_c.NodeButtonModel = function() {
   // super()
   vpx.gui.ToggleButton.ToggleButtonModel.call(this);
};

// NodeButtonModel extends vpx.gui.ToggleButton.ToggleButtonModel
_c.NodeButtonModel.prototype = new vpx.gui.ToggleButton.ToggleButtonModel(vpx.ABSTRACT_PASS);
_c.NodeButtonModel.prototype.constructor = _c.NodeButtonModel;

/**
 * Sets the pressed state of the toggle button. Unlike standard toggle buttons,
 * node buttons remain selected even if they're pressed again after they're
 * alresady selected, so this will not un-select the node button if pressed
 * multiple times.
 *
 * @param b boolean
 *    true to press the button; false to unpress it
 */
_c.NodeButtonModel.prototype.setPressed = function(b) {
   if ((this.isPressed() == b) || !this.isEnabled()) {
      return;
   }

   if (b == false && this.isArmed() && !this.isSelected()) {
      // Uni-directional select
      this.setSelected(true);
   }

   var c = vpx.gui.DefaultButtonModel;
   if (b) {
      this.stateMask |= c.PRESSED;
   } else {
      this.stateMask &= ~c.PRESSED;
   }

   this._fireStateChanged();

   if(!this.isPressed() && this.isArmed()) {
      var ActionEvent = vpx.gui.event.ActionEvent;
      var event = new ActionEvent(this, ActionEvent.ACTION_PERFORMED,
                                  this.getActionCommand());
      this._fireActionPerformed(event);
   }
};
