/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public abstract class Event
 *
 * The root event class for all VPX events.
 */

//?? XXX Fill out with full Java implementation?

vpx.core.Event = function(source, id) {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }

   if (!this._concrete) {
      throw new Error("vpx.core.Event: cannot instantiate abstract class");
   }
   if (!source) {
      throw new Error("vpx.core.Event: null source");
   }
   this.source = source;
   this.id = id;
};

// Shorthand for brevity's sake
var _c = vpx.core.Event;        // Class
var _i = _c.prototype;          // Instance
_i._c = _c;                     // this._c --> static vars (class)

/**
 * The object on which the Event initially occurred.
 *
 * @return Object
 *    The object on which the Event initially occurred
 */
_i.getSource = function() {
   return this.source;
};

/**
 * Returns the event type.
 *
 * @return int
 *    The event type
 */
_i.getId = function() {
   return this.id;
};
