/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public final class System
 * extends Object
 *
 * The <code>System</code> class contains several useful class fields and
 * methods. It cannot be instantiated.
 *
 * @version 1.0 (Dec 8, 2005)
 */

vpx.core.System = function() {
   throw new Error("vpx.core.System is just a container for static methods");
};

// Shorthand for brevity's sake
var _c = vpx.core.System;             // Class

/**
 * Copies an array from the specified source array, beginning at the specified
 * position, to the specified position of the destination array. A subsequence
 * of array components are copied from the source array referenced by
 * <code>src</code> to the destination array referenced by <code>dest</code>.
 * The number of components copied is equal to the <code>length</code>
 * argument. The components at positions <code>srcPos</code> through
 * <code>srcPos+length-1</code> in the source array are copied into positions
 * <code>destPos</code> through <code>destPos+length-1</code>, respectively, of
 * the destination array.
 * <p/>
 * If the <code>src</code> and <code>dest</code> arguments refer to the same
 * array object, then the copying is performed as if the components at
 * positions <code>srcPos</code> through <code>srcPos+length-1</code> were
 * first copied to a temporary array with <code>length</code> components and
 * then the contents of the temporary array were copied into positions
 * <code>destPos</code> through <code>destPos+length-1</code> of the
 * destination array.
 *
 * @param src Array
 *    The source array
 * @param srcPos int
 *    Starting position in the source array
 * @param dest Array
 *    The destination array
 * @param destPos int
 *    Starting position in the destination data
 * @param length int
 *    The number of array elements to be copied
 */
_c.arraycopy = function(src, srcPos, dest, destPos, length) {
   var i;
   if (src == dest) {
      var tmp = new Array();
      for (i = srcPos; i < srcPos + length; i++) {
         tmp[i - srcPos] = src[i];
      }
      for (i = 0; i < tmp.length; i++) {
         dest[i + destPos] = tmp[i];
      }
      delete tmp;
   } else {
      for (i = srcPos; i < srcPos + length; i++) {
         dest[destPos - srcPos + i] = src[i];
      }
   }
};
