/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public abstract class VpxObject
 * extends Object
 *
 * A generic base class for all vpx objects.
 *
 * @version 1.0 (May 10, 2006)
 */

/**
 * Abstract constructor, used to provide common instantiation functionality to
 * concrete children of this class.
 */
vpx.core.VpxObject = function VpxObject() {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }
   if (!this._concrete) {
      throw new Error("vpx.core.VpxObject: cannot instantiate abstract class");
   }
};

// Shorthand for brevity's sake
var _c = vpx.core.VpxObject;          // Class
var _i = _c.prototype;                // Instance
_i._concrete = false;                 // vpx system flag for concrete classes

// Instance variables
_i.dying = false;

/**
 * Vanilla implementation of a destructor.  This base implementation simply
 * flags the object as dying, which can be used by object methods to know
 * that they need to bail out of what they're doing.
 */
_i.destroy = function() {
   this.dying = true;
};
