/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public class ChangeEvent
 * extends vpx.core.Event
 *
 * ChangeEvent is used to notify interested parties that  state has changed in
 * the event source.
 */

/**
 * Constructs a <code>ChangeEvent</code> object.
 *
 * @param source Object
 *    The object that is the source of the event
 * @throws Error
 *    If <code>source</code> is null
 */
vpx.core.event.ChangeEvent = function(source) {
   var id = vpx.core.event.ChangeEvent.STATE_CHANGED;
   vpx.core.Event.call(this, source, id);
};

// ChangeEvent extends vpx.core.Event
vpx.core.event.ChangeEvent.prototype = new vpx.core.Event(vpx.ABSTRACT_PASS);
vpx.core.event.ChangeEvent.prototype.constructor = vpx.core.event.ChangeEvent;

// Shorthand for brevity's sake
var _c = vpx.core.event.ChangeEvent;  // Class
var _i = _c.prototype;                // Instance
_i._concrete = true;                  // vpx system flag for concrete classes

/**
 * This event id indicates a state change.
 */
_c.STATE_CHANGED = 2001;              // public static final int

/**
 * (non-Javadoc)
 *
 * @see Object#toString()
 */
_i.toString = function() {
   var typeStr;
   switch (this.id) {
   case vpx.core.event.ChangeEvent.STATE_CHANGED:
      typeStr = "STATE_CHANGED";
      break;
   default:
      typeStr = "unknown type";
      break;
   }

   return typeStr;
};
