/**
 * Gets the o-based index of the given element in this array.
 *
 * @param el    The element for which to search
 * @return      index, or -1 if not found
 */

Array.prototype.indexOf = function(el) {
   for (var i = 0; i < this.length; i++) {
      if (this[i] == el) return i;
   }
   return -1;
};

/**
 * Compares two arrays using logical equality comparison.  Two arrays are
 * said to be logically equal if they have the same length and contain
 * pairwise elements that are logically equal.
 *
 * @param a     The second array against which to compare
 * @return      true if the arrays are logically equal; false otherwise
 */

Array.prototype.equals = function(a) {
   if (!isArray(a)) {
      return false;
   }
   if (a.length != this.length) {
      return false;
   }
   for (var i = 0; i < this.length; i++) {
      if (isObject(this[i])) {
         if (! arePolyEqual(this[i], a[i])) {
            return false;
         }
      } else if (this[i] != a[i]) {
         return false;
      }
   }
   return true;
};