Date.MONTHS = [
   "Jan",
   "Feb",
   "Mar",
   "Apr",
   "May",
   "Jun",
   "Jul",
   "Aug",
   "Sep",
   "Oct",
   "Nov",
   "Dec"
];

/**
 * Return a date as a formatted string suitable for use in a log message.
 *
 * @return      a string representation of this date.
 */

Date.prototype.toLogString = function() {
   var s = "[" + this.getDate() + "/" + Date.MONTHS[this.getMonth()] + "/";
   s += (this.getYear() + 1900) + ":" + this.getHours() + ":" + this.getMinutes() + ":";
   s += this.getSeconds() + "." + this.getMilliseconds() + "]";
   return s;
};
