/**
 * Return copy of the this object sans leading and trailing whitespace.
 *
 * @return      a copy of the this string object wihtout bounding whitespace.
 */

String.prototype.trim = function () {
   return this.replace(/^\s+(.*?)\s+$/, "$1");
};


/**
 * Converts a string to a boolean value.  The following are recognized values
 * for true: "true", "yes", "on", "1".  The following are recognized values
 * fpr false: "false", "no", "off", "0".  Any other value will throw an error.
 *
 * @return      a boolean value
 * @throws      Error Thrown if the string does not represent a boolean
 */

String.prototype.toBool = function() {
   if (this.search(/^(true|yes|on|1)$/) >= 0) {
      return true;
   } else if (this.search(/^(false|no|off|0)$/) >= 0) {
      return false;
   }
   throw new Error("String#toBool(): value is not boolean: " + this);
};

/**
 * XML escapes a string to eliminate < and > characters in it, thereby making it  
 * a non XML element representation.
 * For example, the string "<element>" will be escaped to become 
 * "&lt;element&gt;" .
 *
 * @return a String not representing an XML element
 */

String.prototype.escapeElement = function() {
   var strTmp = "";
   var i;
   for (i = 0; i < this.length; i++) {
      switch (this.charAt(i)) {
         case '<':
            strTmp += "&lt;";
            break;
         case '>':
            strTmp += "&gt;";
            break;
         default:
            strTmp += this.charAt(i);
      }
   }
   return strTmp;
}