/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public interface InvocationListener
 *
 * Defines an object that listens for invocation events.
 *
 * @version 1.0 (March 30, 2006)
 */


// This file simply defines an interface. It should not be loaded into HTML
throw new Error("Interface vpx.ext.event.InvocationListener cannot be instantiated");


// Shorthand for brevity's sake
var _c = vpx.ext.event.InvocationListener;  // Class
var _i = _c.prototype;                       // Instance


/**
 * Invoked when the monitored invocation succeds. To be overridden by the client.
 */
_i.invocationSucceeded = function() {};

/**
 * Invoked when the monitored invocation fails. To be overridden by the client.
 */
_i.invocationFailed = function() {};