/* Copyright 2005 VMware, Inc.	All rights reserved. -- VMware Confidential */

/**
 * public class Button
 * extends vpx.gui.AbstractButton
 *
 * An implementation of a "push" button.
 * <p/>
 * VPX Buttons are based on Java Swing buttons. For information and examples of
 * using Swing buttons, see
 * <a href="http://java.sun.com/docs/books/tutorial/uiswing/components/button.html">How to Use Buttons, Check Boxes, and Radio Buttons</a>,
 * a section in <em>The Java Tutorial.</em>
 *
 * @version 1.0 (Nov 2, 2005)
 */

/**
 * Creates a button with initial text and an icon.
 *
 * @param view [DOM Level 2 Views]AbstractView
 *    The context in which to create the menubar
 * @param text String
 *    The text of the button
 * @param icon vpx.gui.Icon
 *    The Icon image to display on the button
 */
vpx.gui.Button = function(view, text, icon) {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }

   // super(view)
   vpx.gui.AbstractButton.call(this, view);

   // Create the model
   this.setModel(new vpx.gui.DefaultButtonModel());

   // initialize
   this._initUI();
   this._init(text, icon);
};

// Button extends vpx.gui.AbstractButton
vpx.gui.Button.prototype = new vpx.gui.AbstractButton(vpx.ABSTRACT_PASS);
vpx.gui.Button.prototype.constructor = vpx.gui.Button;

// Shorthand for brevity's sake
var _c = vpx.gui.Button;               // Class
var _i = _c.prototype;                 // Instance
_i._concrete = true;                   // vpx system flag for concrete classes

// Instance variables
_i.uiClassID = "ButtonUI";             // private static final String

/**
 * (non-Javadoc)
 *
 * @see Object#toString()
 */
_i.toString = function() {
   return "[Object vpx.gui.Button]";
};
