/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public class DefaultSingleSelectionModel
 * extends Object
 * implements SingleSelectionModel
 *
 * A generic implementation of SingleSelectionModel.
 *
 * @version 1.0 (Oct 13, 2005)
 */

/**
 * Constructs a default <code>SingleSelectionModel</code>.
 */
vpx.gui.DefaultSingleSelectionModel = function() {
   this.listenerList = new vpx.core.event.EventListenerList();
};

// Shorthand for brevity's sake
var _c = vpx.gui.DefaultSingleSelectionModel;  // Class
var _i = _c.prototype;                         // Instance
_i._concrete = true;                           // vpx system flag for concrete classes

// Instance variables
_i.changeEvent   = null;   // protected transient vpx.core.event.ChangeEvent
_i.listenerList  = null;   // protected vpx.core.event.EventListenerList
_i.index = -1;             // private int

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.SingleSelectionModel#getSelectedIndex()
 */
_i.getSelectedIndex = function() {
   return this.index;
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.SingleSelectionModel#setSelectedIndex(int)
 */
_i.setSelectedIndex = function(i) {
   if (this.index != i) {
      this.index = i;
      this._fireStateChanged();
   }
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.SingleSelectionModel#clearSelection()
 */
_i.clearSelection = function() {
   this.setSelectedIndex(-1);
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.SingleSelectionModel#isSelected()
 */
_i.isSelected = function() {
   if (this.index != -1) {
      return true;
   }
   return false;
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.SingleSelectionModel#addChangeListener(vpx.core.event.ChangeListener)
 */
_i.addChangeListener = function(l) {
   this.listenerList.add("ChangeListener", l);
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.SingleSelectionModel#removeChangeListener(vpx.core.event.ChangeListener)
 */
_i.removeChangeListener = function(l) {
   this.listenerList.remove("ChangeListener", l);
};

/**
 * Returns an array of all the change listeners registered on this
 * <code>DefaultSingleSelectionModel</code>.
 *
 * @return vpx.core.event.ChangeListener[]
 *    All of this model's <code>ChangeListener</code>s or an empty array if no
 *    change listeners are currently registered
 */
_i.getChangeListeners = function() {
   return this.listenerList.getListeners("ChangeListener");
};

/**
 * Notifies all listeners that have registered interest for notification on
 * this event type. The event instance is created lazily.
 */
_i._fireStateChanged = function() {
   // Guaranteed to return a non-null array
   var listeners = this.listenerList.getListenerList();

   // Process listeners last->first, notifying those who're interested in event
   for (var i = listeners.length - 2; i >= 0; i -= 2) {
      if (listeners[i] == "ChangeListener") {
         // Lazily create the event:
         if (this.changeEvent == null) {
            this.changeEvent = new vpx.core.event.ChangeEvent(this);
         }

         // listeners[i + 1] is of type vpx.core.event.ChangeListener
         listeners[i + 1].stateChanged(this.changeEvent);
      }
   }
};
