/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public class GuiUtilities
 * extends Object
 *
 * A collection of utility methods for the VPX gui package.
 *
 * @version 1.0 (Nov 3, 2005)
 */

vpx.gui.GuiUtilities = function() {
   throw new Error("vpx.gui.GuiUtilities is just a container for static methods");
};

// Shorthand for brevity's sake
var _c = vpx.gui.GuiUtilities;        // Class

/**
 * Returns true if the mouse event specifies the left mouse button.
 *
 * @param e vpx.gui.event.MouseEvent
 *    A MouseEvent object
 * @return boolean
 *    true if the left mouse button was active
 */
_c.isLeftMouseButton = function(e) {
   var InputEvent = vpx.gui.event.InputEvent;
   return ((e.getModifiers() & InputEvent.BUTTON1_DOWN_MASK) != 0);
};
