/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public class HeaderMenuItem
 * extends vpx.gui.MenuItem
 *
 * An implementation of a header menu item. A <code>HeaderMenuItem</code> is a
 * menu item that acts as a header in that it is never clickable. It is similar
 * in concept to a <code>Separator</code>, except that it has text and an icon.
 *
 * @version 1.0 (Oct 14, 2005)
 */

/**
 * Creates a header meanu item that has the specified text and image.
 *
 * @param view [DOM Level 2 Views]AbstractView
 *    The context in which to create the menubar
 * @param text String
 *    The string displayed in the header
 * @param icon vpx.gui.Icon
 *    The image that the header should display
 */
vpx.gui.HeaderMenuItem = function(view, text, icon) {
   // super(text, icon)
   vpx.gui.MenuItem.call(this, view, text, icon);

   // super.setEnabled(false)
   var spr = vpx.gui.MenuItem.prototype;
   spr.setEnabled.call(this, false);
};

// HeaderMenuItem extends vpx.gui.MenuItem
vpx.gui.HeaderMenuItem.prototype = new vpx.gui.MenuItem(vpx.ABSTRACT_PASS);
vpx.gui.HeaderMenuItem.prototype.constructor = vpx.gui.HeaderMenuItem;

// Shorthand for brevity's sake
var _c = vpx.gui.HeaderMenuItem;      // Class
var _i = _c.prototype;                // Instance
_i._concrete = true;                  // vpx system flag for concrete classes

// Instance variables
_i.uiClassID = "HeaderMenuItemUI";    // private static final String

/**
 * Enables (or disables) the button.  This throws an error - headers cannot
 * be enabled and disabled. They remain "disabled" at all times.
 *
 * @param b boolean
 *    true to enable the button, otherwise false
 */
_i.setEnabled = function(b) {
   throw new Error("HeaderMenuItem: cannot set enabled state");
};

/**
 * (non-Javadoc)
 *
 * @see Object#toString()
 */
_i.toString = function() {
   return "[Object vpx.gui.HeaderMenuItem]";
};
