/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public interface Icon
 *
 * A small fixed size picture, typically used to decorate components.
 *
 * @see vpx.gui.ImageIcon
 * @version 1.0 (Oct 5, 2005)
 */

// This file simply defines an interface. It should not be loaded into HTML
throw new Error("Interface vpx.gui.Icon cannot be instantiated");

/**
 * Returns the icon's height.
 *
 * @return int
 *    An int specifying the fixed height of the icon
 */
vpx.gui.Icon.prototype.getIconHeight = function() {};

/**
 * Returns the icon's width.
 *
 * @return int
 *    An int specifying the fixed width of the icon
 */
vpx.gui.Icon.prototype.getIconWidth = function() {};
