/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public class ImageIcon
 * extends Object
 * implements Icon
 *
 * An implementation of the Icon interface that creates Icons from Images.
 *
 * @version 1.0 (Oct 5, 2005)
 */

/**
 * Creates an ImageIcon from the specified CSS class.
 *
 * @param view [DOM Level 2 Views]AbstractView
 *    The context in which to create the icon
 * @param className
 *    The CSS class that encapsulates the image icon L&F
 * @param desc String
 *    A brief textual description of the icon.  If null, <code>className</code>
 *    will be used as the description
 */
vpx.gui.ImageIcon = function(view, className, desc) {
   this.view = view;
   this.className = className;
   this.desc = desc ? desc : className;

   this.peer = this._createPeer(view);
   this._init();
};

// Shorthand for brevity's sake
var _c = vpx.gui.ImageIcon;     // Class
var _i = _c.prototype;          // Instance
_i._concrete = true;            // vpx system flag for concrete classes

// Instance variables
_i.view       = null;           // protected [DOM Level 2 Views]AbstractView
_i.className  = null;           // transient private String
_i.peer       = null;           // transient HTMLDivElement
_i.desc       = null;           // String
_i.width      = -1;             // int
_i.height     = -1;             // int

/**
 *
 * @param view [DOM Level 2 Views]AbstractView
 *    The context in which to create the peer
 * @return HTMLDivElement
 *    The peer that supports this icon
 */
_i._createPeer = function(view) {
   return view.document.createElement("div");
};

/**
 * Initializes derived attributes of this <code>ImageIcon</code>.
 */
_i._init = function() {
   this.peer.className = this.className;
   this.peer.setAttribute("alt", this.desc);

   var wS = vpx.xua.style(this.peer, "width");
   if (wS != null && wS != "") {
      this.width = parseInt(wS);
   } else {
      this.width = -1;
   }
   var hS = vpx.xua.style(this.peer, "height");
   if (hS != null && hS != "") {
      this.height = parseInt(hS);
   } else {
      this.height = -1;
   }
};

/**
 * Returns this icon's <code>Image</code>.
 *
 * @return HTMLDivElement
 *    The <code>peer</code> object for this <code>ImageIcon</code>
 */
_i.getPeer = function() {
   return this.peer;
};

/**
 * Gets the description of the image.  This is meant to be a brief textual
 * description of the object.  For example, it might be presented to a blind
 * user to give an indication of the purpose of the image.  The description may
 * be null.
 *
 * @return String
 *    A brief textual description of the image
 */
_i.getDescription = function() {
   return this.desc;
};

/**
 *
 * @param className
 *    The CSS class that encapsulates the peer's L&F
 */
_i.setClassName = function(className) {
   this.className = className;
   this._init();
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.Icon#getIconWidth()
 */
_i.getIconWidth = function() {
   return this.width;
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.Icon#getIconHeight()
 */
_i.getIconHeight = function() {
   return this.height;
};
