/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * package vpx.gui
 * public interface ItemSelectable
 *
 * The interface for objects which contain a set of items for which zero or
 * more can be selected.
 *
 * @version 1.0 (Sept 27, 2005)
 */

// This file simply defines an interface. It should not be loaded into HTML
throw new Error("Interface vpx.gui.ItemSelectable cannot be instantiated");

/**
 * Adds a listener to receive item events when the state of an item is changed
 * by the user. Item events are not sent when an item's state is set
 * programmatically. If <code>l</code> is <code>null</code>, no exception is
 * thrown, and no action is performed.
 *
 * @param l vpx.gui.event.ItemListener
 *    The listener to receive events
 */
vpx.gui.ItemSelectable.prototype.addItemListener = function(l) {};

/**
 * Removes an item listener. If <code>l</code> is <code>null</code>, no
 * exception is thrown, and no action is performed.
 *
 * @param l vpx.gui.event.ItemListener
 *    The listener being removed
 */
vpx.gui.ItemSelectable.prototype.removeItemListener = function(l) {};

/**
 * Returns the selected items.
 *
 * @return Object[]
 *    The selected items, or <code>null</code> if no items are selected
 */
vpx.gui.ItemSelectable.prototype.getSelectedObjects = function() {};
