/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public interface MenuElement
 *
 * Any component that can be placed into a menu should implement this
 * interface. This interface is used by <code>MenuSelectionManager</code>
 * to handle selection and navigation in menu hierarchies.
 *
 * @version 1.0 (Oct 13, 2005)
 */

// This file simply defines an interface. It should not be loaded into HTML
throw new Error("Interface vpx.gui.MenuElement cannot be instantiated");

/**
 * Processes a mouse event. This method should process the
 * <code>MouseEvent</code> and change the menu selection if necessary by using
 * <code>MenuSelectionManager</code>'s API.
 * <p/>
 * Note: you do not have to forward the event to sub-components.
 * This is done automatically by the <code>MenuSelectionManager</code>.
 *
 * @param event [DOM Level 2 Events]MouseEvent
 *    A mouse event with source being the receiving element's component
 * @param path vpx.gui.MenuElement[]
 *    The path of the receiving element in the menu hierarchy, including the
 *    receiving element itself
 * @param manager vpx.gui.MenuSelectionManager
 *    The <code>MenuSelectionManager</code> for the menu hierarchy
 */
vpx.gui.MenuElement.prototype.processMouseEvent = function(event, path[], manager);

/**
 * Called by the <code>MenuSelectionManager</code> when the
 * <code>MenuElement</code> is added or remove from the menu selection.
 *
 * @param isIncluded boolean
 *    true if the <code>MenuElement</code> is now included in the menu
 *    selection; false otherwise
 */
vpx.gui.MenuElement.prototype.menuSelectionChanged = function(isIncluded);

/**
 * This method should return an array containing the sub-elements for the
 * receiving menu element
 *
 * @return vpx.gui.MenuElement[]
 *    An array of MenuElements
 */
vpx.gui.MenuElement.prototype.getSubElements = function();

/**
 * This method should return the <code>Component</code> used to paint the
 * receiving element. The returned component will be used to convert events and
 * detect if an event is inside a <code>MenuElement</code>'s component.
 *
 * @return vpx.gui.Component
 *    The Component value
 */
vpx.gui.MenuElement.prototype.getComponent = function();
