/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

vpx.gui.Point = function(x, y) {
   this.x = x;
   this.y = y;
};

// Shorthand for brevity's sake
var _c = vpx.gui.Point;            // Class
var _i = _c.prototype;             // Instance
_i._concrete = true;               // vpx system flag for concrete classes

// Instance variables
_i.x = null;                       // public int
_i.y = null;                       // public int

/**
 * Returns the X coordinate of the point.
 *
 * @return int
 *    The X coordinate of the point
 */
_i.getX = function() {
   return this.x;
};

/**
 * Returns the Y coordinate of the point.
 *
 * @return int
 *    The Y coordinate of the point
 */
_i.getY = function() {
   return this.y;
};

/**
 * Moves this point to the specified location in the (<i>x</i>, <i>y</i>)
 * coordinate plane.
 *
 * @param x int
 *    The <i>x</i> coordinate of the new location
 * @param y int
 *    The <i>y</i> coordinate of the new location
 */
_i.move = function(x, y) {
   this.x = x;
   this.y = y;
};

/**
 * Translates this point, at location (<i>x</i>, <i>y</i>), by <code>dx</code>
 * along the <i>x</i> axis and <code>dy</code> along the <i>y</i> axis so that
 * it now represents the point (<code>x + dx</code>, <code>y + dy</code>).
 *
 * @param dx int
 *    The distance to move this point along the <i>x</i> axis
 * @param dy int
 *    The distance to move this point along the <i>y</i> axis
 */
_i.translate = function(dx, dy) {
   this.x += dx;
   this.y += dy;
};

/**
 * Determines whether or not two points are equal. Two instances of
 * <code>Point</code> are equal if the values of their <code>x</code> and
 * <code>y</code> member fields, representing their position in the coordinate
 * space, are the same.
 *
 * @param o Object
 *    An object to be compared with this <code>Point</code>
 * @return boolean
 *    <code>true</code> if the object to be compared is an instance of
 *    <code>Point</code> and has the same values; <code>false</code> otherwise.
 */
_i.equals = function(o) {
   if (!(o instanceof vpx.gui.Point)) {
      return false;
   }
   return (this.x == o.x && this.y == o.y);
};

/**
 * (non-Javadoc)
 *
 * @see Object#toString()
 */
_i.toString = function() {
   return "[Object vpx.gui.Point [x=" + this.x + ",y=" + this.y + "]";
};
