/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public interface PopupInvoker
 *
 * The interface for components that are capable of invoking popup menus.
 * <p/>
 * The component that can cause popup menus to be created and shown implements
 * this interface (and all the methods it contains).
 *
 * @version 1.0 (Apr 18, 2006)
 */

// This file simply defines an interface. It should not be loaded into HTML
throw new Error("Interface vpx.gui.PopupInvoker cannot be instantiated");

/**
 * Returns the popup menu associated with this component, if one exists.
 *
 * @return vpx.gui.PopupMenu
 *    The popup menu associated with this component
 */
vpx.gui.PopupInvoker.prototype.getPopupMenu = function() {};

/**
 * Returns true if the component's popup window is visible.
 *
 * @return boolean
 *    true if the popup menu is visible, false otherwise
 */
vpx.gui.PopupInvoker.prototype.isPopupMenuVisible = function() {};

/**
 * Sets the visibility of the component's popup.
 *
 * @param b boolean
 *    true to make the popup menu visible, false to hide it
 */
vpx.gui.PopupInvoker.prototype.setPopupMenuVisible = function(b) {};

