/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public class RadioButtonMenuItem
 * extends vpx.gui.MenuItem
 *
 * An implementation of a radio button menu item. A
 * <code>RadioButtonMenuItem</code> is a menu item that is part of a group of
 * menu items in which only one item in the group can be selected. The selected
 * item displays its selected state. Selecting it causes any other selected
 * item to switch to the unselected state. To control the selected state of a
 * group of radio button menu items, use a <code>ButtonGroup</code> object.
 * <p/>
 * VPX Menus are based on Java Swing menus.  For information and examples of
 * using Swing JMenus, see
 * <a href="http://java.sun.com/doc/books/tutorial/uiswing/components/menu.html">How to Use Menus</a>,
 * a section in <em>The Java Tutorial.</em>
 *
 * @version 1.0 (Oct 14, 2005)
 */

/**
 * Creates a radio button menu item that has the specified text, image, and
 * selection state.
 *
 * @param view [DOM Level 2 Views]AbstractView
 *    The context in which to create the menubar
 * @param text String
 *    The string displayed on the radio button
 * @param icon vpx.gui.Icon
 *    The image that the button should display
 * @param selected boolean
 *    true if the menu item should initially be selected; false otherwise
 */
vpx.gui.RadioButtonMenuItem = function(view, text, icon, selected) {
   // super(view, text, icon, model)
   var model = new vpx.gui.ToggleButton.ToggleButtonModel();
   vpx.gui.MenuItem.call(this, view, text, icon, model);
   this.setSelected(selected);
};

// RadioButtonMenuItem extends vpx.gui.MenuItem
vpx.gui.RadioButtonMenuItem.prototype = new vpx.gui.MenuItem(vpx.ABSTRACT_PASS);
vpx.gui.RadioButtonMenuItem.prototype.constructor = vpx.gui.RadioButtonMenuItem;

// Shorthand for brevity's sake
var _c = vpx.gui.RadioButtonMenuItem;    // Class
var _i = _c.prototype;                   // Instance
_i._concrete = true;                     // vpx system flag for concrete classes

// Instance variables
_i.uiClassID = "RadioButtonMenuItemUI";  // private static final String

/**
 * (non-Javadoc)
 *
 * @see Object#toString()
 */
_i.toString = function() {
   return "[Object vpx.gui.RadioButtonMenuItem]";
};
