/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * Creates a new separator.
 *
 * @param view [DOM Level 2 Views]AbstractView
 *    The context in which to create the separator
 */
vpx.gui.Separator = function(view) {
   // super(view)
   vpx.gui.Component.call(this, view);

   this._initUI();
};

// Separator extends vpx.gui.Component
vpx.gui.Separator.prototype = new vpx.gui.Component(vpx.ABSTRACT_PASS);
vpx.gui.Separator.prototype.constructor = vpx.gui.Separator;

// Shorthand for brevity's sake
var _c = vpx.gui.Separator;           // Class
var _i = _c.prototype;                // Instance
_i._concrete = true;                  // vpx system flag for concrete classes

// Instance variables
_i.uiClassID = "SeparatorUI";         // private static final String

/**
 * (non-Javadoc)
 *
 * @see Object#toString()
 */
_i.toString = function() {
   return "[Object vpx.gui.Separator]";
};
