/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public interface SingleSelectionModel
 *
 * A model that supports at most one indexed selection.
 *
 * @version 1.0 (Oct 13, 2005)
 */

// This file simply defines an interface. It should not be loaded into HTML
throw new Error("Interface vpx.gui.SingleSelectionModel cannot be instantiated");

/**
 * Returns the model's selection.
 *
 * @return int
 *    The model's selection, or -1 if there is no selection
 */
vpx.gui.SingleSelectionModel.prototype.getSelectedIndex = function();

/**
 * Sets the model's selected index to <code>i</code> and notifies any listeners
 * if the model changes.
 *
 * @param i int
 *    An int specifying the model selection
 */
vpx.gui.SingleSelectionModel.prototype.setSelectedIndex = function(i);

/**
 * Clears the selection (to -1).
 */
vpx.gui.SingleSelectionModel.prototype.clearSelection = function();

/**
 * Returns true if the selection model currently has a selected value.
 *
 * @return boolean
 *    true if a value is currently selected; false otherwise
 */
vpx.gui.SingleSelectionModel.prototype.isSelected = function();

/**
 * Adds <code>listener</code> as a listener to changes in the model.
 *
 * @param l vpx.core.event.ChangeListener
 *    The ChangeListener to add
 */
vpx.gui.SingleSelectionModel.prototype.addChangeListener = function(l);

/**
 * Removes <code>listener</code> as a listener to changes in the model.
 *
 * @param l vpx.core.event.ChangeListener
 *    The ChangeListener to remove
 */
vpx.gui.SingleSelectionModel.prototype.removeChangeListener = function(l);
