/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public classActionEvent
 * extends vpx.core.Event
 *
 * A semantic event which indicates that a component-defined action occurred.
 * This high-level event is generated by a component (such as a
 * <code>Button</code>) when the component-specific action occurs (such as
 * being pressed). The event is passed to every <code>ActionListener</code>
 * object that registered to receive such events using the component's
 * <code>addActionListener</code> method.
 * <p/>
 * The object that implements the <code>ActionListener</code> interface
 * gets this <code>ActionEvent</code> when the event occurs. The listener
 * is therefore spared the details of processing individual mouse movements
 * and mouse clicks, and can instead process a "meaningful" (semantic)
 * event like "button pressed".
 */

/**
 * Constructs an <code>ActionEvent</code> object.
 * <p>
 * Note that passing in an invalid <code>id</code> results in unspecified
 * behavior. A <code>null</code> <code>command</code> string is legal but not
 * recommended.
 *
 * @param source Object
 *    The object that originated the event
 * @param id int
 *    An integer that identifies the event
 * @param command String
 *    A string that may specify a command (possibly one of several) associated
 *    with the event
 * @throws Error
 *    If <code>source</code> is null
 */
vpx.gui.event.ActionEvent = function(source, id, command) {
   vpx.core.Event.call(this, source, id);
   this.actionCommand = command;
};

// ActionEvent extends vpx.core.Event
vpx.gui.event.ActionEvent.prototype = new vpx.core.Event(vpx.ABSTRACT_PASS);
vpx.gui.event.ActionEvent.prototype.constructor = vpx.gui.event.ActionEvent;

// Shorthand for brevity's sake
var _c = vpx.gui.event.ActionEvent;     // Class
var _i = _c.prototype;                  // Instance
_i._c = _c;                             // this._c --> static vars (class)
_i._concrete = true;                    // vpx system flag for concrete classes

// Instance variables
_i.actionCommand = null;                // String

/**
 * This event id indicates that a meaningful action occured.
 */
_c.ACTION_PERFORMED = 1001;             // public static final int

/**
 * Returns the command string associated with this action.
 * This string allows a "modal" component to specify one of several
 * commands, depending on its state. For example, a single button might
 * toggle between "show details" and "hide details". The source object
 * and the event would be the same in each case, but the command string
 * would identify the intended action.
 * <p/>
 * Note that if a <code>null</code> command string was passed
 * to the constructor for this <code>ActionEvent</code>, this
 * this method returns <code>null</code>.
 *
 * @return String
 *    The string identifying the command for this event
 */
_i.getActionCommand = function() {
   return this.actionCommand;
};

/**
 * (non-Javadoc)
 *
 * @see Object#toString()
 */
_i.toString = function() {
   var typeStr;
   switch (this.id) {
   case vpx.gui.event.ActionEvent.ACTION_PERFORMED:
      typeStr = "ACTION_PERFORMED";
      break;
   default:
      typeStr = "unknown type";
      break;
   }

   return typeStr + ",cmd=" + this.actionCommand;
};
