/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public interface ActionListener
 *
 * The listener interface for receiving action events. The class that is
 * interested in processing an action event implements this interface, and the
 * object created with that class is registered with a component, using the
 * component's <code>addActionListener</code> method. When the action event
 * occurs, that object's <code>actionPerformed</code> method is invoked.
 *
 * @version 1.0 (Sept 27, 2005)
 */

// This file simply defines an interface. It should not be loaded into HTML
throw new Error("Interface vpx.gui.event.ActionListener cannot be instantiated");

/**
 * Invoked when an action occurs.
 *
 * @param e vpx.gui.event.ActionEvent
 *    The action event
 */
vpx.gui.event.ActionListener.prototype.actionPerformed = function(e) {};
