/* Copyright 2006 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public interface ComponentAttributeListener
 *
 * This listener interface can be implemented in order to get notifications of
 * changes to the attribute lists of components.
 *
 * @version 1.0 (Jun 21, 2006)
 */

// This file simply defines an interface. It should not be loaded into HTML
throw new Error("Interface vpx.gui.event.ComponentAttributeListener cannot be instantiated");

/**
 * Notification that an attribute has been added to a component. Called after
 * the attribute is added.
 *
 * @param e vpx.gui.event.ComponentBindingEvent
 *    The binding event
 */
vpx.gui.event.ComponentAttributeListener.prototype.attributeAdded = function(e) {};

/**
 * Notification that an attribute has been removed from a component. Called
 * after the attribute is removed.
 *
 * @param e vpx.gui.event.ComponentBindingEvent
 *    The binding event
 */
vpx.gui.event.ComponentAttributeListener.prototype.attributeRemoved = function(e) {};

/**
 * Notification that an attribute has been replaced in a component. Called
 * after the attribute is replaced.
 *
 * @param e vpx.gui.event.ComponentBindingEvent
 *    The binding event
 */
vpx.gui.event.ComponentAttributeListener.prototype.attributeReplaced = function(e) {};
