/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public class ComponentEvent
 * extends vpx.core.Event
 *
 * ComponentEvent is used to notify interested parties thata component has
 * changed its size or location.
 */

/**
 * Constructs a <code>ComponentEvent</code> object.
 *
 * @param source Object
 *    The object that is the source of the event
 * @throws Error
 *    If <code>source</code> is null
 */
vpx.gui.event.ComponentEvent = function(source) {
   var id = vpx.gui.event.ComponentEvent.PLACEMENT_CHANGED;
   vpx.core.Event.call(this, source, id);
};

// ComponentEvent extends vpx.core.Event
vpx.gui.event.ComponentEvent.prototype = new vpx.core.Event(vpx.ABSTRACT_PASS);
vpx.gui.event.ComponentEvent.prototype.constructor = vpx.gui.event.ComponentEvent;

// Shorthand for brevity's sake
var _c = vpx.gui.event.ComponentEvent;   // Class
var _i = _c.prototype;                   // Instance
_i._concrete = true;                     // vpx system flag for concrete classes

/**
 * This event id indicates a placement change.
 */
_c.PLACEMENT_CHANGED = 2301;             // public static final int

/**
 * (non-Javadoc)
 *
 * @see Object#toString()
 */
_i.toString = function() {
   var typeStr;
   switch (this.id) {
   case vpx.gui.event.ComponentEvent.PLACEMENT_CHANGED:
      typeStr = "PLACEMENT_CHANGED";
      break;
   default:
      typeStr = "unknown type";
      break;
   }

   return typeStr;
};
