/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public class ContainerEvent
 * extends vpx.core.Event
 *
 * A low-level event which indicates that a container's contents changed
 * because a component was added or removed.
 * <p/>
 * Container events are provided for notification purposes ONLY; The VPX GUI
 * will automatically handle changes to the containers' contents internally so
 * that the program works properly regardless of whether the program is
 * receiving these events or not.
 * <p/>
 * This low-level event is generated by a container object (such as a MenuBar)
 * when a component is added to it or removed from it. The event is passed to
 * every <code>ContainerListener</code> object that registered to receive such
 * events using the component's <code>addContainerListener</code> method. Each
 * such listener object gets this <code>ContainerEvent</code> when the event
 * occurs.
 *
 * @version 1.0 (Oct 12, 2005)
 */

/**
 * Constructs a <code>ContainerEvent</code> object.
 * <p/>
 * Note that passing in an invalid <code>id</code> results in unspecified
 * behavior.
 *
 * @param source vpx.gui.Component
 *    The <code>Component</code> object (container) that originated the event
 * @param id int
 *    An integer indicating the type of event
 * @param child vpx.gui.Component
 *    The component that was added or removed
 * @throws Error
 *    If <code>source</code> is null
 */
vpx.gui.event.ContainerEvent = function(source, id, child) {
   vpx.core.Event.call(this, source, id);
   this.child = child;
};

// ContainerEvent extends vpx.core.Event
vpx.gui.event.ContainerEvent.prototype = new vpx.core.Event(vpx.ABSTRACT_PASS);
vpx.gui.event.ContainerEvent.prototype.constructor = vpx.gui.event.ContainerEvent;

// Shorthand for brevity's sake
var _c = vpx.gui.event.ContainerEvent;      // Class
var _i = _c.prototype;                      // Instance
_i._concrete = true;                        // vpx system flag for concrete classes

// Instance variables
_i.child = null;                            // private vpx.gui.Component

/**
 * This event indicates that a component was added to the container.
 */
_c.COMPONENT_ADDED   = 300;                 // public static final int

/**
 * This event indicates that a component was removed from the container.
 */
_c.COMPONENT_REMOVED = 300;                 // public static final int

/**
 * Returns the originator of the event.
 *
 * @return vpx.gui.Component
 *    The <code>Component</code> object that originated the event
 */
_i.getContainer = function() {
   return this.source;
};

/**
 * Returns the component that was affected by the event.
 *
 * @return vpx.gui.Component
 *    The Component object that was added or removed
 */
_i.getChild = function() {
   return this.child;
};

/**
 * (non-Javadoc)
 *
 * @see Object#toString()
 */
_i.toString = function() {
   var typeStr;
   var cls = vpx.gui.event.ContainerEvent;
   switch (this.id) {
   case cls.COMPONENT_ADDED:
      typeStr = "COMPONENT_ADDED";
      break;
   case cls.COMPONENT_REMOVED:
      typeStr = "COMPONENT_REMOVED";
      break;
   default:
      typeStr = "unknown type";
      break;
   }

   return typeStr + ",child=" + this.child;
};
