/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public interface ContainerListener
 *
 * The listener interface for receiving container events. The class that is
 * interested in processing a container event implements this interface (and
 * all the methods it contains). The listener object created from that class is
 * then registered with a component using the component's
 * <code>addContainerListener</code> method. When the container's contents
 * change because a component has been added or removed, the relevant method in
 * the listener object is invoked, and the <code>ContainerEvent</code> is
 * passed to it.
 * <p/>
 * Container events are provided for notification purposes ONLY; The VPX GUI
 * will automatically handle add and remove operations internally so the
 * program works properly regardless of whether the program registers a
 * <code>ContainerListener</code> or not.
 *
 * @version 1.0 (Oct 12, 2005)
 */

// This file simply defines an interface. It should not be loaded into HTML
throw new Error("Interface vpx.gui.event.ContainerListener cannot be instantiated");

/**
 * Invoked when a component has been added to the container.
 *
 * @param e vpx.gui.event.ContainerEvent
 *    The event object describing the event source and the component that has
 *    been added
 */
vpx.gui.event.ContainerListener.prototype.componentAdded = function(e) {};

/**
 * Invoked when a component has been removed from the container.
 *
 * @param e vpx.gui.event.ContainerEvent
 *    The event object describing the event source and the component that has
 *    been removed
 */
vpx.gui.event.ContainerListener.prototype.componentRemoved = function(e) {};
