/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public interface ItemListener
 *
 * The listener interface for receiving item events. The class that is
 * interested in processing an item event implements this interface. The object
 * created with that class is then registered with a component using the
 * component's <code>addItemListener</code> method. When an item-selection
 * event occurs, the listener object's <code>itemStateChanged</code> method is
 * invoked.
 *
 * @version 1.0 (Sept 27, 2005)
 */

// This file simply defines an interface. It should not be loaded into HTML
throw new Error("Interface vpx.gui.event.ItemListener cannot be instantiated");

/**
 * Invoked when an item has been selected or deselected by the user. The code
 * written for this method performs the operations that need to occur when an
 * item is selected (or deselected).
 *
 * @param e vpx.gui.event.ItemEvent
 *    The item event
 */
vpx.gui.event.ItemListener.prototype.itemStateChanged = function(e) {};
