/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public class MenuEvent
 * extends vpx.core.Event
 *
 * MenuEvent is used to notify interested parties that the menu which is the
 * event source has been posted, selected, or canceled.
 *
 * @version 1.0 (Oct 7, 2005)
 */

/**
 * Constructs a <code>MenuEvent</code> object.
 *
 * @param source Object
 *    The object that originated the event (typically <code>this</code>)
 * @throws Error
 *    If <code>source</code> is null
 */
vpx.gui.event.MenuEvent = function(source) {
   var id = vpx.gui.event.MenuEvent.MENU_CHANGED;
   vpx.core.Event.call(this, source, id);
};

// MenuEvent extends vpx.core.Event
vpx.gui.event.MenuEvent.prototype = new vpx.core.Event(vpx.ABSTRACT_PASS);
vpx.gui.event.MenuEvent.prototype.constructor = vpx.gui.event.MenuEvent;

// Shorthand for brevity's sake
var _c = vpx.gui.event.MenuEvent;     // Class
var _i = _c.prototype;                // Instance
_i._concrete = true;                  // vpx system flag for concrete classes

/**
 * This event id indicates a menu state change.
 */
_c.MENU_CHANGED = 2201;               // public static final int

/**
 * (non-Javadoc)
 *
 * @see Object#toString()
 */
_i.toString = function() {
   var typeStr;
   switch (this.id) {
   case vpx.gui.event.MenuEvent.MENU_CHANGED:
      typeStr = "MENU_CHANGED";
      break;
   default:
      typeStr = "unknown type";
      break;
   }

   return typeStr;
};
