/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public interface MenuListener
 *
 * Defines an object which listens for MenuEvents.
 *
 * @version 1.0 (Oct 7, 2005)
 */

// This file simply defines an interface. It should not be loaded into HTML
throw new Error("Interface vpx.gui.event.MenuListener cannot be instantiated");

/**
 * Invoked when a menu is selected.
 *
 * @param e vpx.gui.event.MenuEvent
 *    A MenuEvent object
 */
vpx.gui.event.MenuListener.prototype.menuSelected = function(e) {};

/**
 * Invoked when the menu is deselected.
 *
 * @param e vpx.gui.event.MenuEvent
 *    A MenuEvent object
 */
vpx.gui.event.MenuListener.prototype.menuDeselected = function(e) {};

/**
 * Invoked when the menu is canceled.
 *
 * @param e vpx.gui.event.MenuEvent
 *    A MenuEvent object
 */
vpx.gui.event.MenuListener.prototype.menuCanceled = function(e) {};
