/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public interface MouseListener
 *
 * The listener interface for receiving "interesting" mouse events (press,
 * release, click, enter, and exit) on a component.
 * <p/>
 * The class that is interested in processing a mouse event implements this
 * interface (and all the methods it
 * contains).
 * <p/>
 * The listener object created from that class is then registered with a
 * component using the component's <code>addMouseListener</code>  method. A
 * mouse event is generated when the mouse is pressed, released clicked
 * (pressed and released). A mouse event is also generated when the mouse
 * cursor enters or leaves a component. When a mouse event occurs, the relevant
 * method in the listener object is invoked, and the <code>MouseEvent</code> is
 * passed to it.
 *
 * @version 1.0 (Oct 13, 2005)
 */

// This file simply defines an interface. It should not be loaded into HTML
throw new Error("Interface vpx.gui.event.MouseListener cannot be instantiated");

/**
 * Invoked when the mouse button has been clicked (pressed and released) on a
 * component.
 *
 * @param e vpx.gui.event.MouseEvent
 *    The <code>MouseEvent</code> object
 */
vpx.gui.event.MouseListener.prototype.mouseClicked = function(e) {};

/**
 * Invoked when a mouse button has been pressed on a component.
 *
 * @param e vpx.gui.event.MouseEvent
 *    The <code>MouseEvent</code> object
 */
vpx.gui.event.MouseListener.prototype.mousePressed = function(e) {};

/**
 * Invoked when a mouse button has been released on a component.
 *
 * @param e vpx.gui.event.MouseEvent
 *    The <code>MouseEvent</code> object
 */
vpx.gui.event.MouseListener.prototype.mouseReleased = function(e) {};

/**
 * Invoked when the mouse enters a component.
 *
 * @param e vpx.gui.event.MouseEvent
 *    The <code>MouseEvent</code> object
 */
vpx.gui.event.MouseListener.prototype.mouseEntered = function(e) {};

/**
 * Invoked when the mouse exits a component.
 *
 * @param e vpx.gui.event.MouseEvent
 *    The <code>MouseEvent</code> object
 */
vpx.gui.event.MouseListener.prototype.mouseExited = function(e) {};
