/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public interface PropertyChangeListener
 *
 * A "PropertyChange" event gets fired whenever a component changes a "bound"
 * property.  You can register a PropertyChangeListener with a source component
 * so as to be notified of any bound property updates.
 *
 * @version 1.0 (Oct 6, 2005)
 */

// This file simply defines an interface. It should not be loaded into HTML
throw new Error("Interface vpx.gui.event.PropertyChangeListener cannot be instantiated");

/**
 * This method gets called when a bound property is changed.
 *
 * @param e vpx.gui.event.PropertyChangeEvent
 *    The event object describing the event source and the property that has
 *    changed.
 */
vpx.gui.event.PropertyChangeListener.prototype.propertyChange = function(e) {};
