/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public class ButtonListener
 * extends Object
 * implements vpx.core.event.ChangeListener,
 *            vpx.gui.event.MouseListener,
 *            vpx.gui.event.PropertyChangeListener
 *
 * Basic button listener.
 *
 * @version 1.0 (Nov 3, 2005)
 */

vpx.gui.plaf.ButtonListener = function() {
};

// Shorthand for brevity's sake
var _c = vpx.gui.plaf.ButtonListener;        // Class
var _i = _c.prototype;                       // Instance
_i._concrete = true;                         // vpx system flag for concrete classes
_i._IMPL_vpx_gui_event_MouseListener = true; // vpx system flag for interface impl
_i._IMPL_vpx_gui_event_PropertyChangeListener = true;

/**
 * (non-Javadoc)
 *
 * @see vpx.core.event.ChangeListener#stateChanged(vpx.core.event.ChangeEvent)
 */
_i.stateChanged = function(e) {
   var icon, s;

   var b = e.getSource();
   var model = b.getModel();
   var p = b.getPeer();

   if (model.isEnabled()) {
      p.style.cursor = "pointer";
      icon = b.getIcon();
      if (icon != null) {
         s = b.ui.getPeerSection(b.ui.PEER_SECTION_ICON);
         if (s.hasChildNodes()) {
            s.removeChild(s.firstChild);
         }
         s.appendChild(icon.getPeer());
      }
   } else {
      p.style.cursor = "default";
      icon = b.getDisabledIcon();
      if (icon != null && b.getIcon() != null) {
         s = b.ui.getPeerSection(b.ui.PEER_SECTION_ICON);
         if (s.hasChildNodes()) {
            s.removeChild(s.firstChild);
         }
         s.appendChild(icon.getPeer());
      }
   }
};

/**
 *
 *
 * @see vpx.gui.event.MouseListener#mouseClicked(vpx.gui.event.MouseEvent)
 */
_i.mouseClicked = function(e) {
   // Do nothing - handled in mousePressed() & mouseReleased()
};

/**
 *
 *
 * @see vpx.gui.event.MouseListener#mousePressed(vpx.gui.event.MouseEvent)
 */
_i.mousePressed = function(e) {
   var GuiUtilities = vpx.gui.GuiUtilities;
   if (GuiUtilities.isLeftMouseButton(e)) {
      var b = e.getSource();

      //XXX Add support for multiClickThreshhold?

      var model = b.getModel();
      if (!model.isEnabled()) {
         // Disabled buttons ignore all input...
         return;
      }
      if (!model.isArmed()) {
         // button not armed, should be
         model.setArmed(true);
      }
      model.setPressed(true);
   }
};

/**
 *
 *
 * @see vpx.gui.event.MouseListener#mouseReleased(vpx.gui.event.MouseEvent)
 */
_i.mouseReleased = function(e) {
   var GuiUtilities = vpx.gui.GuiUtilities;
   if (GuiUtilities.isLeftMouseButton(e)) {
      //XXX Add support for multiClickThreshhold?

      var b = e.getSource();
      var model = b.getModel();
      model.setPressed(false);
      model.setArmed(false);
   }
};

/**
 *
 *
 * @see vpx.gui.event.MouseListener#mouseEntered(vpx.gui.event.MouseEvent)
 */
_i.mouseEntered = function(e) {
   var GuiUtilities = vpx.gui.GuiUtilities;
   var b = e.getSource();
   var model = b.getModel();
   //?? XXX GuiUtilities.isLeftMouseButton() is broken - don't use for now
   //if (b.isRolloverEnabled() && !GuiUtilities.isLeftMouseButton(e)) {
   if (b.isRolloverEnabled()) {
      model.setRollover(true);
   }
   if (model.isPressed()) {
      model.setArmed(true);
   }
};

/**
 *
 *
 * @see vpx.gui.event.MouseListener#mouseExited(vpx.gui.event.MouseEvent)
 */
_i.mouseExited = function(e) {
   var b = e.getSource();
   var model = b.getModel();
   if (b.isRolloverEnabled()) {
      model.setRollover(false);
   }
   model.setArmed(false);
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.event.PropertyChangeListener#propertyChange(vpx.gui.event.PropertyChangeEvent)
 */
_i.propertyChange = function(e) {
   var icon, s;

   var name = e.getPropertyName();
   var button = e.getSource();

   switch (name) {

   case vpx.gui.AbstractButton.TEXT_CHANGED_PROPERTY:
      var s = button.ui.getPeerSection(button.ui.PEER_SECTION_CONTENT);
      var tooltipPeer = button.ui.getTooltipPeer();
      var text = e.getNewValue();
      if (s.hasChildNodes()) {
         s.removeChild(s.firstChild);
      }
      if (text != null) {
         var doc = button.getView().document;
         var txtNode = doc.createTextNode(text);
         var doWidthCheck = (s.offsetWidth > 0);
         if (tooltipPeer != null) {
            // Reset the tooltip
            tooltipPeer.title = "";
         }
         if (doWidthCheck) {
            var baseWidth = s.offsetWidth;
            s.appendChild(txtNode);
            if (s.offsetWidth > baseWidth) {
               // Clipping will occur
               if (tooltipPeer != null) {
                  tooltipPeer.title = text;
               }
               var txt = text;
               if (vpx.xua.ie) {
                  /**
                   * TCV 04/10/06; BEGIN Fix PR #100166
                   *
                   * IE does not automatically re-flow outer element when inner
                   * element's 'nodeValue' is updated.  Thus, we set outer element
                   * so be 1px wide to force a re-flow.  Then we'll set it back
                   * once we're done with our width checks.
                   */
                  s.style.width = "1px";
               }
               while (s.offsetWidth > baseWidth) {
                  // Cut tail char off until txt fits
                  txt = txt.substring(0, txt.length - 1);
                  txtNode.nodeValue = txt + "...";
                  if (txt == "") {
                     // Base case; hopefully will never happen
                     break;
                  }
               }
               if (vpx.xua.ie) {
                  /**
                   * TCV 04/10/06; END Fix PR #100166
                   */
                  s.style.width = "";
               }
            }
         } else {
            s.appendChild(txtNode);
         }
      }
      break;

   case vpx.gui.AbstractButton.ICON_CHANGED_PROPERTY:
      if (button.isEnabled()) {
         s = button.ui.getPeerSection(button.ui.PEER_SECTION_ICON);
         icon = e.getNewValue();
         if (s.hasChildNodes()) {
            s.removeChild(s.firstChild);
         }
         if (icon != null) {
            s.appendChild(icon.getPeer());
         }
      }
      break;

   case vpx.gui.AbstractButton.DISABLED_ICON_CHANGED_PROPERTY:
      if (!button.isEnabled()) {
         s = button.ui.getPeerSection(button.ui.PEER_SECTION_ICON);
         icon = e.getNewValue();
         if (s.hasChildNodes()) {
            s.removeChild(s.firstChild);
         }
         if (icon != null) {
            s.appendChild(icon.getPeer());
         }
      }
      break;

   case vpx.gui.Component.VISIBILITY_PROPERTY:
      var p = button.ui.peer;
      var visible = e.getNewValue();
      p.style.visibility = visible ? "visible" : "hidden";
      break;

   default:
      ; // Leave the button unchanged
      break;

   }
};
