/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public  class ButtonUI
 * extends ComponentUI
 *
 * UI implementation for buttons.
 *
 * @version 1.0 (Nov 3, 2005)
 */

/**
 *
 */
vpx.gui.plaf.ButtonUI = function() {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }

   // super()
   vpx.gui.plaf.ComponentUI.call(this);
};

// ButtonUI extends vpx.gui.plaf.ComponentUI
vpx.gui.plaf.ButtonUI.prototype = new vpx.gui.plaf.ComponentUI(vpx.ABSTRACT_PASS);
vpx.gui.plaf.ButtonUI.prototype.constructor = vpx.gui.plaf.ButtonUI;

// Shorthand for brevity's sake
var _c = vpx.gui.plaf.ButtonUI;        // Class
var _i = _c.prototype;                 // Instance
_i._concrete = true;                   // vpx system flag for concrete classes

// Class variables
_i.PEER_SECTION_ICON     = 0;
_i.PEER_SECTION_CONTENT  = 1;
_i.PEER_SECTION_CHILDREN = 2;

// Instance variables
_i.button = null;                      // protected vpx.gui.AbstractButton

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.plaf.ComponentUI#installUI(vpx.gui.Component)
 */
_i.installUI = function(c) {
   this.initPeer(c);
   this.button = c;

   this.installDefaults();
   this.installListeners(c);
};

/**
 * Installs the default look of this UI.
 */
_i.installDefaults = function() {
   var p = this.peer;
   p.style.width = p.style.height = "16px";
   p.style.cursor = "pointer";
   p.style.padding = "0px";
};

/**
 *
 * @param b vpx.gui.AbstractButton
 *    The button on which this ui is being installed
 */
_i.installListeners = function(b) {
   var listener = this._createButtonListener();
   if (listener != null) {
      b.addChangeListener(listener);
      b.addMouseListener(listener);
      b.addGlobalPropertyChangeListener(listener);
   }
};

/**
 *
 * @return vpx.gui.plaf.ButtonListener
 *    A basic button listener
 */
_i._createButtonListener = function() {
   return new vpx.gui.plaf.ButtonListener();
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.plaf.ComponentUI#_initSections()
 */
_i._initSections = function() {
   this.sections = [];
   this.sections[this.PEER_SECTION_ICON] = null;
   this.sections[this.PEER_SECTION_CONTENT] = null;
   this.sections[this.PEER_SECTION_CHILDREN] = null;
};
