/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public class FilmUI
 * extends ComponentUI
 *
 * UI implementation for films.
 *
 * @version 1.0 (Oct 25, 2005)
 */

/**
 *
 */
vpx.gui.plaf.FilmUI = function() {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }

   // super()
   vpx.gui.plaf.ComponentUI.call(this);
};

// FilmUI extends vpx.gui.plaf.ComponentUI
vpx.gui.plaf.FilmUI.prototype = new vpx.gui.plaf.ComponentUI(vpx.ABSTRACT_PASS);
vpx.gui.plaf.FilmUI.prototype.constructor = vpx.gui.plaf.FilmUI;

// Shorthand for brevity's sake
var _c = vpx.gui.plaf.FilmUI;         // Class
var _i = _c.prototype;                // Instance
_i._concrete = true;                  // vpx system flag for concrete classes

// Instance variables
_i.coverPeer = null;                  // protected HTMLElement
_i.film = null;                       // protected vpx.gui.Film
_i.handler  = null;                   // protected vpx.gui.plaf.FilmUI.Handler

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.plaf.ComponentUI#installUI(vpx.gui.Component)
 */
_i.installUI = function(c) {
   this.initPeer(c);
   this.film = c;

   this.installDefaults();
   this.installListeners();
};

_i.installDefaults = function() {
   var p = this.peer;
   var cp = this.coverPeer;

   // Peer
   p.style.position = "absolute";
   p.style.zIndex = "1";
   p.style.top = p.style.left = "0px";
   p.style.width = p.style.height = "100%";
   // Uncomment the following two lines for debugging
   //p.style.backgroundColor = "#990000";
   //vpx.xua.setOpacity(p, 0.2);

   // Cover peer
   cp.setAttribute("frameborder", "0");
   cp.setAttribute("scrolling", "no");
   cp.setAttribute("src", vpx.xua.BLANK_FRAME_SRC);
   cp.style.position = "absolute";
   cp.style.zIndex = "1";
   cp.style.top = cp.style.left = "0px";
   cp.style.width = cp.style.height = "100%";
   vpx.xua.setOpacity(cp, 0);

   // Default visibility
   var visible = this.film.isVisible();
   p.style.display = cp.style.display = (visible ? "" : "none");
};

_i.installListeners = function() {
   this.film.addGlobalPropertyChangeListener(this.getHandler());
};

/**
 * Creates a new native peer DOM element that will be responsible for the
 * actual rendering of this UI.  This implementation also creates an
 * <code>HTMLIFrameElement</code>, to act as the cover.
 *
 * @param c vpx.gui.Component
 *    The component that this peer will be attached to
 * @return HTMLElement
 *    A newly created native peer
 * @see vpx.gui.plaf.ComponentUI#initPeer(vpx.gui.Component)
 */
_i.initPeer = function(c) {
   // super.initPeer(c)
   var spr = vpx.gui.plaf.ComponentUI.prototype;
   spr.initPeer.call(this, c);

   // Create the cover peer
   var cp = c.getView().document.createElement("iframe");
   this.coverPeer = cp;

   return this.peer;
};

_i.getHandler = function() {
   if (this.handler == null) {
      this.handler = new vpx.gui.plaf.FilmUI.Handler(this);
   }
   return this.handler;
};

/**
 * class Handler
 * extends Object
 * implements vpx.gui.event.PropertyChangeListener
 *
 * Listener that automatically gets registered with this ui's film.
 *
 * @version 1.0 (Oct 18, 2005)
 */

/**
 * Constructs a new Handler.
 */
_c.Handler = function(ui) {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }

   this.ui = ui;
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.event.PropertyChangeListener#propertyChange(vpx.gui.event.PropertyChangeEvent)
 */
_c.Handler.prototype.propertyChange = function(e) {
   var name = e.getPropertyName();
   var p = this.ui.peer;
   var cp = this.ui.coverPeer;

   if (name == vpx.gui.Component.VISIBILITY_PROPERTY) {
      var visible = e.getNewValue();
      p.style.display = cp.style.display = (visible ? "" : "none");
   }
};
