/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public class FrameUI
 * extends ComponentUI
 *
 * UI implementation for vanilla frames.
 *
 * @version 1.0 (Oct 18, 2005)
 */

/**
 *
 */
vpx.gui.plaf.FrameUI = function() {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }

   // super()
   vpx.gui.plaf.ComponentUI.call(this);
};

// FrameUI extends vpx.gui.plaf.ComponentUI
vpx.gui.plaf.FrameUI.prototype = new vpx.gui.plaf.ComponentUI(vpx.ABSTRACT_PASS);
vpx.gui.plaf.FrameUI.prototype.constructor = vpx.gui.plaf.FrameUI;

// Shorthand for brevity's sake
var _c = vpx.gui.plaf.FrameUI;        // Class
var _i = _c.prototype;                // Instance
_i._concrete = true;                  // vpx system flag for concrete classes

// Instance variables
_i.frame = null;                      // protected vpx.gui.Frame
_i.handler  = null;                   // protected vpx.gui.plaf.FrameUI.Handler

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.plaf.ComponentUI#installUI(vpx.gui.Component)
 */
_i.installUI = function(c) {
   this.initPeer(c);
   this.frame = c;

   this.installDefaults();
   this.installListeners();
};

_i.installDefaults = function() {
   var p = this.peer;

   p.style.position = "absolute";
   p.style.zIndex = "103";
   p.style.visibility = "hidden";
};

_i.installListeners = function() {
   this.frame.addGlobalPropertyChangeListener(this.getHandler());
};

_i.getHandler = function() {
   if (this.handler == null) {
      this.handler = new vpx.gui.plaf.FrameUI.Handler(this);
   }
   return this.handler;
};

/**
 * class Handler
 * extends Object
 * implements vpx.gui.event.PropertyChangeListener
 *
 * Listener that automatically gets registered with this ui's frame.
 *
 * @version 1.0 (Oct 18, 2005)
 */

/**
 * Constructs a new Handler.
 */
_c.Handler = function(ui) {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }

   this.ui = ui;
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.event.PropertyChangeListener#propertyChange(vpx.gui.event.PropertyChangeEvent)
 */
_c.Handler.prototype.propertyChange = function(e) {
   var name = e.getPropertyName();
   var p = this.ui.peer;

   if (name == vpx.gui.Component.PREF_SIZE_PROPERTY) {
      var dim = e.getNewValue();
      if (dim != null) {
         p.style.width = dim.width + "px";
         p.style.height = dim.height + "px";
      } else {
         p.style.width = p.style.height = "";
      }
   }
};
