/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public class HeaderMenuItemUI
 * extends MenuItemUI
 *
 * UI implementation for header menu items.
 *
 * @version 1.0 (Oct 14, 2005)
 */

/**
 *
 */
vpx.gui.plaf.HeaderMenuItemUI = function() {
   // super()
   vpx.gui.plaf.MenuItemUI.call(this);
};

// HeaderMenuItemUI extends vpx.gui.plaf.MenuItemUI
vpx.gui.plaf.HeaderMenuItemUI.prototype = new vpx.gui.plaf.MenuItemUI(vpx.ABSTRACT_PASS);
vpx.gui.plaf.HeaderMenuItemUI.prototype.constructor = vpx.gui.plaf.HeaderMenuItemUI;

// Shorthand for brevity's sake
var _c = vpx.gui.plaf.HeaderMenuItemUI;  // Class
var _i = _c.prototype;                   // Instance
_i._concrete = true;                     // vpx system flag for concrete classes

_i.installDefaults = function() {
   // super.installDefaults()
   var spr = vpx.gui.plaf.MenuItemUI.prototype;
   spr.installDefaults.call(this);

   var p = this.peer;
   p.style.color = "black";
   p.style.cursor = "default";
   p.style.fontWeight = "bold";
   p.style.padding = "4px 20px 4px 4px";
};

_i.installListeners = function() {
   var l = this._createButtonListener();
   if (l != null) {
      this.menuItem.addGlobalPropertyChangeListener(l);
   }
};
