/* Copyright 2005 VMware, Inc.   All rights reserved. -- VMware Confidential */

/**
 * public  class MenuBarUI
 * extends ComponentUI
 *
 * UI implementation for menu bars.
 *
 * @version 1.0 (Oct 12, 2005)
 */

/**
 *
 */
vpx.gui.plaf.MenuBarUI = function() {
   if (arguments[0] == vpx.ABSTRACT_PASS) {
      // Skip object initialization
      return;
   }

   // super()
   vpx.gui.plaf.ComponentUI.call(this);
};

// MenuBarUI extends vpx.gui.plaf.ComponentUI
vpx.gui.plaf.MenuBarUI.prototype = new vpx.gui.plaf.ComponentUI(vpx.ABSTRACT_PASS);
vpx.gui.plaf.MenuBarUI.prototype.constructor = vpx.gui.plaf.MenuBarUI;

// Shorthand for brevity's sake
var _c = vpx.gui.plaf.MenuBarUI;       // Class
var _i = _c.prototype;                 // Instance
_i._concrete = true;                   // vpx system flag for concrete classes

// Instance variables
_i.menuBar = null;                     // protected vpx.gui.MenuBar
_i.handler  = null;                    // protected vpx.gui.plaf.MenuBarUI.Handler
_i.changeListener = null;              // protected vpx.core.event.ChangeListener
_i.containerListener = null;           // protected vpx.gui.event.ContainerListener
_i.rowPeer = null;                     // protected transient HTMLTableRowElement

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.plaf.ComponentUI#installUI(vpx.gui.Component)
 */
_i.installUI = function(c) {
   this.initPeer(c);
   this.menuBar = c;

   this.installDefaults();
   this.installListeners();
};

_i.installDefaults = function() {
   var p = this.peer;
   var rp = this.rowPeer;
   p.cellPadding = p.cellSpacing = p.border = "0";
   rp.style.lineHeight = "21px";
   p.style.margin = "0px 6px 0px 6px";
   p.style.padding = "0px";
};

_i.installListeners = function() {
   this.changeListener = this.createChangeListener();
   this.containerListener = this.createContainerListener();

   var count = this.menuBar.getMenuCount();
   for (var i = 0; i < count; i++) {
      var menu = this.menuBar.getMenu(i);
      if (menu != null) {
         menu.getModel().addChangeListener(this.changeListener);
      }
   }
   this.menuBar.addContainerListener(this.containerListener);
};

/**
 * Creates a new native peer DOM element that will be responsible for the
 * actual rendering of this UI.  This implementation creates an
 * <code>HTMLTableElement</code>, with a corresponding body and row.
 *
 * @param c vpx.gui.Component
 *    The component that this peer will be attached to
 * @return HTMLElement
 *    A newly created native peer
 * @see vpx.gui.plaf.ComponentUI#initPeer(vpx.gui.Component)
 */
_i.initPeer = function(c) {
   var doc = c.getView().document;
   var t = doc.createElement("table");
   var b = doc.createElement("tbody");
   var r = doc.createElement("tr");
   t.appendChild(b);
   b.appendChild(r);
   this.peer = t;
   this.rowPeer = r;
   return t;
};

/**
 * Appends the given <code>Component</code> to this ui's peer.  This places
 * the component's peer into a new <code>HTMLTableCellElement</code> in this
 * ui's peer <code>HTMLTableElement</code>.
 *
 * @param c vpx.gui.Component
 *    The component whose peer should be appended to this ui's peer element
 * @see vpx.gui.plaf.ComponentUI#appendToPeer(vpx.gui.Component)
 */
_i.appendToPeer = function(c) {
   var doc = this.menuBar.getView().document;
   var td = doc.createElement("td");
   td.style.whiteSpace = "nowrap";
   this.rowPeer.appendChild(td);
   td.appendChild(c.getPeer());
};

_i.createChangeListener = function() {
   return this.getHandler();
};

_i.createContainerListener = function() {
   return this.getHandler();
};

_i.getHandler = function() {
   if (this.handler == null) {
      this.handler = new vpx.gui.plaf.MenuBarUI.Handler(this);
   }
   return this.handler;
};

/**
 * class Handler
 * extends Object
 * implements vpx.core.event.ChangeListener, vpx.gui.event.ContainerListener
 *
 * Listener that automatically gets registered with this ui's menu bar.
 *
 * @version 1.0 (Oct 12, 2005)
 */

/**
 * Constructs a new Handler.
 */
_c.Handler = function(ui) {
   this.ui = ui;
};

/**
 * (non-Javadoc)
 *
 * @see vpx.core.event.ChangeListener#stateChanged(vpx.core.event.ChangeEvent)
 */
_c.Handler.prototype.stateChanged = function(e) {
   var menuBar = this.ui.menuBar;
   var c = menuBar.getMenuCount();
   for (var i = 0; i < c; i++) {
      var menu = menuBar.getMenu(i);
      if (menu != null && menu.isSelected()) {
         menuBar.getSelectionModel().setSelectedIndex(i);
         break;
      }
   }
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.event.ContainerListener#componentAdded(vpx.gui.event.ContainerEvent)
 */
_c.Handler.prototype.componentAdded = function(e) {
   var c = e.getChild();
   if (c instanceof vpx.gui.Menu) {
      c.getModel().addChangeListener(this.ui.changeListener);
   }
};

/**
 * (non-Javadoc)
 *
 * @see vpx.gui.event.ContainerListener#componentRemoved(vpx.gui.event.ContainerEvent)
 */
_c.Handler.prototype.componentRemoved = function(e) {
   var c = e.getChild();
   if (c instanceof vpx.gui.Menu) {
      c.getModel().removeChangeListener(this.ui.changeListener);
   }
};
